/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 10.10.2006
 */
package org.simantics.utils.ui.gfx;


/**
 * PhysicalDimension
 * @author Toni Kalajainen
 */
public class PhysicalDimension {

    /** Width in meters */
    public final double width;

    /** height in meters */
    public final double height;
    
    private final int hash;

    public PhysicalDimension(double width, double height) {
        this.width = width;
        this.height = height;
        this.hash = makeHash(width, height);
    }

    public PhysicalDimension(PixelDimension d) {
        this(d.width, d.height);
    }
    
    public double getHeight() {
        return height;
    }

    public double getWidth() {
        return width;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PixelDimension))
            return false;
        PixelDimension d = (PixelDimension) obj;
        return (width == d.width) && (height == d.height);
    }

    public int hashCode() {        
        return hash;
    }

    private static int makeHash(Double w, Double h) {
        return w.hashCode() ^ (h.hashCode()*7);
    }
    
    @Override
    public String toString() {
        return "PhysicalDimension [w=" + width + ", h=" + height + "]";
    }
    
    /**
     * returns aspect ratio (width / height)
     * @return returns aspect ratio (width / height)
     */
    public double getAspectRatio()
    {
        return width / height;
    }
    
}
