package org.simantics.utils.ui.dialogs;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * This class shows an error, Throwable or IStatus. Can be instantiated from any thread.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ShowError implements Runnable {

    private String title;

    private String message;

    private Throwable error;

    private Display display;

    private IStatus status;

    public ShowError(String title, String message, Throwable error) {
        this.title = title;
        this.message = message;
        this.error = error;
        this.display = getDisplay();
        display.asyncExec(this);
    }

    public ShowError(Display display, String title, String message, Throwable error) {
        this.title = title;
        this.message = message;
        this.error = error;
        this.display = display;
        display.asyncExec(this);
    }

    public ShowError(String title, String message, Throwable error, boolean sync) {
        this.title = title;
        this.message = message;
        this.error = error;
        this.display = getDisplay();
        if (sync)
            display.syncExec(this);
        else
            display.asyncExec(this);
    }

    public ShowError(Display display, String title, String message, Throwable error, boolean sync) {
        this.title = title;
        this.message = message;
        this.error = error;
        this.display = display;
        if (sync)
            display.syncExec(this);
        else
            display.asyncExec(this);
    }

    public ShowError(String title, String message,IStatus status) {
        this.title = title;
        this.message = message;
        this.status = status;
        this.display = getDisplay();
        display.asyncExec(this);
    }

    public ShowError(Display display,String title, String message, IStatus status) {
        this.title = title;
        this.message = message;
        this.status = status;
        this.display = display;
        display.asyncExec(this);
    }

    public ShowError(String title, String message,IStatus status, boolean sync) {
        this.title = title;
        this.message = message;
        this.status = status;
        this.display = getDisplay();
        if (sync)
            display.syncExec(this);
        else
            display.asyncExec(this);
    }

    public ShowError(Display display,String title, String message, IStatus status, boolean sync) {
        this.title = title;
        this.message = message;
        this.status = status;
        this.display = display;
        if (sync)
            display.syncExec(this);
        else
            display.asyncExec(this);
    }

    public Display getDisplay() {
        if (display!=null) return display;
        Display d = Display.getCurrent();
        if (d!=null) return d;
        return Display.getDefault();
    }

    public void run() {
        Shell shell = display.getActiveShell();
        if (error == null && status != null) {
            org.eclipse.jface.dialogs.ErrorDialog.openError(shell, title, message, status);
        } else {
            ErrorDialog dialog = new ErrorDialog(shell, title, message, error);
            dialog.open();
        }
    }

    public static void showError(String title, String message, Throwable error) {
        new ShowError(title, message, error);
    }

    public static void showError(String title, String message,IStatus status) {
        new ShowError(title, message, status);
    }


    private class ErrorDialog extends IconAndMessageDialog {

        private String title;
        //private String message;
        private Text messageText;
        private Text errorText;
        private String errorString;

        protected ErrorDialog(Shell parentShell, String title, String message, Throwable error) {
            super(parentShell);
            this.title = title;
            this.message = message;
            if (error != null) {
                StringWriter sw = new StringWriter();
                error.printStackTrace(new PrintWriter(sw));
                this.errorString = sw.toString();
            }
            setShellStyle(getShellStyle() | SWT.RESIZE);
        }

        @Override
        protected Image getImage() {
            return getErrorImage();
        }

        @Override
        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(title);
            newShell.setImage(newShell.getDisplay().getSystemImage(SWT.ICON_ERROR));
        }

//        @Override
//        protected Control createDialogArea(Composite parent) {
//            Composite composite = new Composite(parent, SWT.NONE);
//            GridLayout layout = new GridLayout();
//            layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
//            layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
//            layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
//            layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
//            composite.setLayout(layout);
//            composite.setLayoutData(new GridData(GridData.FILL_BOTH));
//            applyDialogFont(composite);
//
//
//            Text label = new Text(composite, SWT.MULTI);
//            label.setEditable(false);
//            if (message != null)
//                label.setText(message);
//            else
//                label.setText("no message");
//
//            return composite;
//        }

        protected Control createMessageArea(Composite composite) {
            // create image
            Image image = getImage();
            if (image != null) {
                imageLabel = new Label(composite, SWT.NULL);
                image.setBackground(imageLabel.getBackground());
                imageLabel.setImage(image);
                GridDataFactory.fillDefaults().align(SWT.CENTER, SWT.BEGINNING)
                        .applyTo(imageLabel);
            }
            // create message
            if (message != null) {
                messageText = new Text(composite, SWT.MULTI | SWT.BORDER | SWT.FLAT | SWT.WRAP | SWT.H_SCROLL | SWT.V_SCROLL);
                messageText.setEditable(false);
                messageText.setText(message);
                GridDataFactory
                        .fillDefaults()
                        .grab(true, true)
                        .hint(
                                convertHorizontalDLUsToPixels(IDialogConstants.MINIMUM_MESSAGE_AREA_WIDTH),
                                SWT.DEFAULT).applyTo(messageText);
            }
            return composite;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, SWT.NONE);

            createMessageArea(composite);

            GridLayout layout = new GridLayout();
            layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
            layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
            layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
            layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
            layout.numColumns = 2;
            composite.setLayout(layout);
            GridData childData = new GridData(GridData.FILL_BOTH);
            childData.horizontalSpan = 2;
            childData.grabExcessVerticalSpace = true;
            composite.setLayoutData(childData);
            applyDialogFont(composite);

            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            // create OK and Cancel buttons by default
            createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
                    true);
            if (errorString != null)
                createButton(parent, IDialogConstants.DETAILS_ID,
                        IDialogConstants.SHOW_DETAILS_LABEL, false);
        }

        @Override
        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == IDialogConstants.DETAILS_ID) {
                if (errorText == null) {
                    errorText = new Text((Composite)getDialogArea(), SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL);
                    errorText.setText(errorString);
                    GridDataFactory.fillDefaults().span(2, 1).applyTo(errorText);
                } else {
                    errorText.dispose();
                    errorText = null;
                }
                resize();
            }
        }

        protected void resize() {
            Point size = getInitialSize();
            Point location = getInitialLocation(size);
            getShell().setBounds(getConstrainedShellBounds(new Rectangle(location.x,
                    location.y, size.x, size.y)));
        }

    }

}
