/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads.logger;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.IThreadLogger;

public class ThreadLogger
implements IThreadLogger {
    private static final ITask DUMMY = () -> {};
    public static String LOG_FILE = "threads.log";
    public static boolean LOG = false;
    static Object loggerCreationLock = new Object();
    static ThreadLogger logger = null;
    DataOutput log;

    public ThreadLogger() {
        if (LOG) {
            try {
                FileOutputStream stream = new FileOutputStream(LOG_FILE);
                this.log = new DataOutputStream(stream);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadLogger getInstance() {
        if (logger == null) {
            Object object = loggerCreationLock;
            synchronized (object) {
                if (logger == null) {
                    logger = new ThreadLogger();
                }
            }
        }
        return logger;
    }

    @Override
    public ITask begin(String taskName) {
        return new Task(taskName);
    }

    public static final ITask task(Object taskName) {
        if (LOG) {
            return ThreadLogger.getInstance().begin(taskName.toString());
        }
        return DUMMY;
    }

    public class Task
    implements ITask {
        String name;
        long beginTime;
        long endTime;
        long threadId;

        public Task(String name) {
            this.name = name;
            this.threadId = Thread.currentThread().getId();
            this.beginTime = System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() {
            this.endTime = System.nanoTime();
            if (LOG && ThreadLogger.this.log != null) {
                try {
                    DataOutput dataOutput = ThreadLogger.this.log;
                    synchronized (dataOutput) {
                        ThreadLogger.this.log.writeUTF(this.name);
                        ThreadLogger.this.log.writeLong(this.threadId);
                        ThreadLogger.this.log.writeLong(this.beginTime);
                        ThreadLogger.this.log.writeLong(this.endTime);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

