/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/

package org.simantics.utils.threads.ua;

import java.util.concurrent.Executor;

/**
 *
 * 
 * @author Toni Kalajainen (toni.kalajainen@vtt.fi)
 */
public interface StatefulExecutor extends IStatefulObject<ExecutorState, RuntimeException>, Executor {

	/**
	 * Change the status of the executor. 
	 * <p>
	 * To close the executor set the state to <tt>WorkerState.Shutdown</tt>.
	 * When all work has been executed and all threads are shut down, 
	 * the executor will shift to WorkerState.Terminated state.
	 * <p>
	 * Once worker is terminated it cannot be re-activated.
	 *  
	 * @param newStatus 
	 */
	boolean setState(ExecutorState newStatus); 	
	
}
