/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/

package org.simantics.utils.threads.ua;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * 
 * 
 * @author Toni Kalajainen (toni.kalajainen@vtt.fi)
 */
public interface IStatefulObject<StateType, ErrorType extends Throwable> {

	void addStateListener(StateListener<StateType> listener);
	void removeStateListener(StateListener<StateType> listener);
	StateType getState();
	
	/**
	 * Wait until state changes to one of the given states.
	 * 
	 * @param set states that ends waiting  
	 * @throws InterruptedException
	 * @return the state in the given set that broke the wait 
	 */
	StateType waitForState(Set<StateType> set) 
	throws InterruptedException, ErrorType;
	
	/**
	 * Wait until state changes to one of the given states.
	 * 
	 * @param set states that ends waiting  
	 * @return the state in the given set that broke the wait 
	 */
	StateType waitForStateUninterruptibly(Set<StateType> set) 
	throws ErrorType;	
	
	
	/**
	 * Wait until state changes to one of the given states or until
	 * time out occurs. 
	 * 
	 * @param set
	 * @param timeout
	 * @param unit
	 * @return state one in set
	 * @throws InterruptedException thread was interrupted
	 * @throws TimeoutException timeout occured
	 */
	StateType waitForState(Set<StateType> set, long timeout, TimeUnit unit) 
	throws InterruptedException, TimeoutException, ErrorType;

	/**
	 * Get error state or null
	 * @return error
	 */
	ErrorType getError();
	
}
