/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.threads;

/**
 * IThreadAccess is an interface for thread context switching.
 * 
 * TODO Yield that makes the thread do other tasks in queue
 * 
 * @Todo Queue open method + QueueClosed exception
 * @see SWTThread
 * @see AWTThread
 * @see CurrentThread
 * @author Toni Kalajainen
 */
public interface IThreadWorkQueue {

	/**
	 * Execute runnable asynchronously.
	 * <p>
	 * Note!
	 * Do not call this method directly unless the instance has been wrapped with 
	 * ThreadUtils.getBetterThreadAccess(), if not use ThreadUtils.asyncExec.
	 * 
	 * 
	 * @param runnable
	 * @return the thread that is processing the runnable or null if thread refused to accept event
	 */
	Thread asyncExec(Runnable runnable);
	
	/**
	 * Execute runnable synchronously. 
	 * This invocation will block until runnable has been executed.
	 * Note!
	 * Do not call this method directly unless the instance has been wrapped with 
	 * ThreadUtils.getBetterThreadAccess(), if not use ThreadUtils.syncExec.
	 * 
	 * @param runnable
	 * @return true if thread accepted the event, false if not
	 */
	boolean syncExec(Runnable runnable);
	
	/**
	 * Is the current thread the same as this access
	 * @return <code>true</code> if current thread is the same as this queue uses
	 */
	boolean currentThreadAccess();
	
	/**
	 * Get the thread. May return null if the thread has not been initialized.
	 * The returned thread may also change right after call if no runnables are
	 * in queue.
	 * 
	 * @return thread or null
	 */
	Thread getThread();

}
