/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.disposable;

import java.lang.reflect.Method;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.disposable.IDisposable;
import org.simantics.utils.datastructures.disposable.IDisposeListener;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;

public abstract class AbstractDisposable
implements IDisposable {
    SyncListenerList<IDisposeListener> disposeListeners = null;
    private DisposeState disposeStatus = DisposeState.Alive;
    private static final Method onDisposed = SyncListenerList.getMethod(IDisposeListener.class, (String)"onDisposed");

    protected void assertNotDisposed() {
        if (this.isDisposed()) {
            throw new AssertionError((Object)(this + " is disposed."));
        }
    }

    @Override
    public DisposeState getDisposeState() {
        return this.disposeStatus;
    }

    @Override
    public boolean isDisposed() {
        return this.disposeStatus == DisposeState.Disposed;
    }

    public boolean isAlive() {
        return this.disposeStatus == DisposeState.Alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void dispose() {
        try {
            block19: {
                AbstractDisposable abstractDisposable = this;
                // MONITORENTER : abstractDisposable
                if (this.disposeStatus != DisposeState.Disposing) break block19;
                // MONITOREXIT : abstractDisposable
                AbstractDisposable abstractDisposable2 = this;
                {
                    catch (Throwable throwable) {
                        // MONITOREXIT : abstractDisposable
                        throw throwable;
                    }
                }
                // MONITORENTER : abstractDisposable2
                this.disposeStatus = DisposeState.Disposed;
                // MONITOREXIT : abstractDisposable2
                return;
            }
            this.assertNotDisposed();
            this.disposeStatus = DisposeState.Disposing;
            // MONITOREXIT : abstractDisposable
        }
        catch (Throwable throwable) {
            AbstractDisposable abstractDisposable = this;
            // MONITORENTER : abstractDisposable
            this.disposeStatus = DisposeState.Disposed;
            // MONITOREXIT : abstractDisposable
            throw throwable;
        }
        {
            try {
                this.fireDisposed();
            }
            finally {
                this.doDispose();
            }
        }
        AbstractDisposable abstractDisposable = this;
        // MONITORENTER : abstractDisposable
        this.disposeStatus = DisposeState.Disposed;
        // MONITOREXIT : abstractDisposable
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void safeDispose() {
        try {
            block19: {
                AbstractDisposable abstractDisposable = this;
                // MONITORENTER : abstractDisposable
                if (this.disposeStatus == DisposeState.Alive) break block19;
                // MONITOREXIT : abstractDisposable
                AbstractDisposable abstractDisposable2 = this;
                {
                    catch (Throwable throwable) {
                        // MONITOREXIT : abstractDisposable
                        throw throwable;
                    }
                }
                // MONITORENTER : abstractDisposable2
                this.disposeStatus = DisposeState.Disposed;
                // MONITOREXIT : abstractDisposable2
                return;
            }
            this.disposeStatus = DisposeState.Disposing;
            // MONITOREXIT : abstractDisposable
        }
        catch (Throwable throwable) {
            AbstractDisposable abstractDisposable = this;
            // MONITORENTER : abstractDisposable
            this.disposeStatus = DisposeState.Disposed;
            // MONITOREXIT : abstractDisposable
            throw throwable;
        }
        {
            try {
                this.fireDisposed();
            }
            finally {
                this.doDispose();
            }
        }
        AbstractDisposable abstractDisposable = this;
        // MONITORENTER : abstractDisposable
        this.disposeStatus = DisposeState.Disposed;
        // MONITOREXIT : abstractDisposable
        return;
    }

    protected abstract void doDispose();

    protected boolean hasDisposeListeners() {
        return this.disposeListeners != null && !this.disposeListeners.isEmpty();
    }

    private void fireDisposed() {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.fireEventSync(onDisposed, new Object[]{this});
    }

    private void fireDisposedAsync() {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.fireEventAsync(onDisposed, new Object[]{this});
    }

    @Override
    public void addDisposeListener(IDisposeListener listener) {
        this.lazyGetListenerList().add((Object)listener);
    }

    @Override
    public void addDisposeListener(IDisposeListener listener, IThreadWorkQueue thread) {
        this.lazyGetListenerList().add(thread, (Object)listener);
    }

    @Override
    public void removeDisposeListener(IDisposeListener listener) {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.remove((Object)listener);
    }

    @Override
    public void removeDisposeListener(IDisposeListener listener, IThreadWorkQueue thread) {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.remove(thread, (Object)listener);
    }

    private synchronized SyncListenerList<IDisposeListener> lazyGetListenerList() {
        if (this.disposeListeners == null) {
            this.disposeListeners = new SyncListenerList(IDisposeListener.class);
        }
        return this.disposeListeners;
    }
}

