/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/

package org.simantics.utils.datastructures.disposable;

import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * Interface for disposable objects.
 * 
 * @see AbstractDisposable for implementation
 * @author Toni Kalajainen
 */
public interface IDisposable {
    
    /**
     * Starts dispose procedures. The objects goes into Disposing state
     * while dispose listeners are handled. 
     */
    void dispose();
    
    /**
     * Dispose if not diposed.
     */
    void safeDispose();
    
    /**
     * Is the object disposed. The return value of this method goes into 
     * true status, once dispose() is invoked and all listeners have been
     * processed. 
     *  
     * @return <code>true</code> if this object has been disposed
     */
    boolean isDisposed();

    /**
     * Get objects state in respect to its life cycle.
     * 
     * @return current object state
     */
    DisposeState getDisposeState();
    
    void addDisposeListener(IDisposeListener listener);
    void addDisposeListener(IDisposeListener listener, IThreadWorkQueue thread);
    void removeDisposeListener(IDisposeListener listener);
    void removeDisposeListener(IDisposeListener listener, IThreadWorkQueue thread);
    
    

}
