/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;

public class SingletonCollection<T> extends ImmutableSet<T> {

    T content;        
    
    public SingletonCollection(T content) {
        this.content = content;
    }

    @Override
    public boolean contains(Object o) {
        return content.equals(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for(Object o : c)
            if(!content.equals(o))
                return false;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return content == null;
    }
    
    static class SingletonIterator<T> extends ImmutableIterator<T> {

        T content;
        
        public SingletonIterator(T content) {
            this.content = content;
        }

        @Override
        public boolean hasNext() {
            return(content != null);
        }

        @Override
        public T next() {
            T ret = content;
            content = null;
            return ret;
        }
        
    }

    @Override
    public Iterator<T> iterator() {
        return new SingletonIterator<T>(content);
    }

    @Override
    public int size() {
        if(content == null)
            return 0;
        else
            return 1;
    }

}
