/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.ErrorLogger;

public class SimpleEditorAdapter
extends AbstractResourceEditorAdapter {
    private final String editorViewId;
    private final String perspectiveId;
    private final String[] inherits;
    private final String[] instanceOf;

    public SimpleEditorAdapter(String name, String editorViewId, String[] inherits, String[] instanceOf) {
        this(name, null, editorViewId, inherits, instanceOf);
    }

    public SimpleEditorAdapter(String name, ImageDescriptor icon, String editorViewId, String[] inherits, String[] instanceOf) {
        this(name, icon, editorViewId, null, inherits, instanceOf);
    }

    public SimpleEditorAdapter(String name, ImageDescriptor icon, String editorViewId, String perspectiveId, String[] inherits, String[] instanceOf) {
        super(name, icon);
        this.editorViewId = editorViewId;
        this.perspectiveId = perspectiveId;
        this.inherits = inherits;
        this.instanceOf = instanceOf;
    }

    @Override
    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        int n;
        int n2;
        String[] stringArray;
        if (!(this.inherits != null && this.inherits.length != 0 || this.instanceOf != null && this.instanceOf.length != 0)) {
            return true;
        }
        if (this.inherits != null) {
            stringArray = this.inherits;
            n2 = this.inherits.length;
            n = 0;
            while (n < n2) {
                String type = stringArray[n];
                try {
                    if (g.isInheritedFrom(r, g.getResource(type))) {
                        return true;
                    }
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((String)("BUG: SimpleEditorAdapter " + this.getClass().getName() + " checked for inheritance of '" + type + "' but resource was not found"), (Throwable)e);
                }
                ++n;
            }
        }
        if (this.instanceOf != null) {
            stringArray = this.instanceOf;
            n2 = this.instanceOf.length;
            n = 0;
            while (n < n2) {
                String instance = stringArray[n];
                try {
                    if (g.isInstanceOf(r, g.getResource(instance))) {
                        return true;
                    }
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((String)("BUG: SimpleEditorAdapter " + this.getClass().getName() + " checked for instanceOf '" + instance + "' but the type was not found"), (Throwable)e);
                }
                ++n;
            }
        }
        return false;
    }

    @Override
    protected void openEditor(Resource r) throws Exception {
        assert (this.editorViewId != null);
        if (this.perspectiveId != null) {
            this.openEditorWithIdInPerspective(this.editorViewId, new ResourceEditorInput(this.editorViewId, r), this.perspectiveId);
        } else {
            this.openEditorWithId(this.editorViewId, new ResourceEditorInput(this.editorViewId, r));
        }
    }

    protected void openView(Resource r) throws Exception {
        assert (this.editorViewId != null);
        if (this.perspectiveId != null) {
            this.openViewWithIdInPerspective(this.editorViewId, r, this.perspectiveId);
        } else {
            this.openViewWithId(this.editorViewId, r);
        }
    }
}

