/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.editor;

import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapterDescriptor;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphEditorAdapterDescriptor
implements EditorAdapterDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphEditorAdapterDescriptor.class);
    private final String editorId;
    private final String label;
    private final ImageDescriptor imageDescriptor;
    private final Resource contribution;
    private final int priority;

    public GraphEditorAdapterDescriptor(String editorId, String label, ImageDescriptor imageDescriptor, Resource contribution, int priority) {
        this.editorId = editorId;
        this.label = label;
        this.imageDescriptor = imageDescriptor;
        this.contribution = contribution;
        this.priority = priority;
    }

    @Override
    public String getId() {
        return this.editorId;
    }

    @Override
    public String getGroupId() {
        return null;
    }

    @Override
    public EditorAdapter getAdapter() {
        return new AbstractResourceEditorAdapter(this.editorId, null, this.priority){

            @Override
            public String getName() {
                return GraphEditorAdapterDescriptor.this.label;
            }

            @Override
            public ImageDescriptor getIcon() {
                return GraphEditorAdapterDescriptor.this.imageDescriptor;
            }

            @Override
            public int getPriority() {
                return this.priority;
            }

            @Override
            public boolean canHandle(ReadGraph graph, Resource input) throws DatabaseException {
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Boolean result = (Boolean)Simantics.tryInvokeSCL((ReadGraph)graph, (Resource)GraphEditorAdapterDescriptor.this.contribution, (Resource)MOD.EditorContribution_canHandle, (Object)input);
                if (result == null) {
                    return false;
                }
                return result;
            }

            @Override
            public void openEditor(Object input) throws Exception {
                final Resource r = ResourceAdaptionUtils.toSingleResource(input);
                Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph g) throws DatabaseException {
                        Variable variable = Variables.getVariable((ReadGraph)g, (Resource)r);
                        final Resource model = (Resource)g.syncRequest((Read)new PossibleIndexRoot(r));
                        final RVI rvi = variable.getPossibleRVI(g);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    WorkbenchUtils.openEditor((String)GraphEditorAdapterDescriptor.this.editorId, (IEditorInput)new ResourceEditorInput2(GraphEditorAdapterDescriptor.this.editorId, r, model, rvi));
                                }
                                catch (PartInitException e) {
                                    LOGGER.error("Failed to open the graph editor", (Throwable)e);
                                }
                            }
                        });
                    }
                });
            }
        };
    }

    @Override
    public Collection<String> getInContexts() {
        return null;
    }

    @Override
    public boolean isActive(Collection<?> activeContextIds) {
        return true;
    }
}

