/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.editor;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.osgi.framework.Bundle;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.ui.internal.Activator;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapterDescriptor;
import org.simantics.ui.workbench.editor.EditorAdapterDescriptorImpl;
import org.simantics.ui.workbench.editor.EditorMapping;
import org.simantics.ui.workbench.editor.EditorMappingImpl;
import org.simantics.ui.workbench.editor.GraphEditorAdapterDescriptor;
import org.simantics.ui.workbench.editor.IEditorRegistry;
import org.simantics.ui.workbench.editor.Prioritized;
import org.simantics.ui.workbench.editor.SimpleEditorAdapter;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.ui.ExceptionUtils;

public final class EditorRegistry
implements IExtensionChangeHandler,
IEditorRegistry {
    private static final int MAX_CACHE_SIZE = 50;
    private static final String NAMESPACE = "org.simantics.ui";
    private static final String EP_NAME = "resourceEditorAdapter";
    private static final String EL_NAME_ADAPTER = "adapter";
    private static final String EL_NAME_ADAPTERCLASS = "adapterClass";
    private static final String EL_NAME_GROUP = "group";
    private static final String EL_NAME_IN_CONTEXT = "inContext";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_IMAGE = "image";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_TYPE_URIS = "type_uris";
    private static final String ATTR_EDITOR_ID = "editorId";
    private static final String ATTR_PRIORITY = "priority";
    private static final String ATTR_GROUP_ID = "groupId";
    private static final String ATTR_ID = "id";
    private static final Comparator<EditorAdapter> ADAPTER_COMPARATOR = (o1, o2) -> -(o1.getPriority() - o2.getPriority());
    private static final EditorAdapter[] EMPTY_ADAPTER_ARRAY = new EditorAdapter[0];
    private static EditorRegistry INSTANCE;
    private ExtensionTracker tracker;
    private EditorAdapterDescriptorImpl[] extensions = new EditorAdapterDescriptorImpl[0];
    private Map<String, EditorAdapterDescriptorImpl> idToExtension = new HashMap<String, EditorAdapterDescriptorImpl>();
    private Map<String, Group> groupMap = new HashMap<String, Group>();
    private WeakHashMap<Object, EditorAdapter[]> adapterCache = new WeakHashMap(50);
    private CircularBuffer<Object> cacheQueue = new CircularBuffer(50);
    private Set<String> referencedContextIds = new HashSet<String>();
    private Set<String> activeContextIds = new HashSet<String>();
    private final EditorMappingImpl editorMapping = new EditorMappingImpl();
    private final IContextManagerListener contextListener = new IContextManagerListener(){

        public void contextManagerChanged(ContextManagerEvent event) {
            if (event.isActiveContextsChanged()) {
                Set active = event.getContextManager().getActiveContextIds();
                Set previouslyActive = event.getPreviouslyActiveContextIds();
                HashSet<String> added = new HashSet<String>(4);
                HashSet<String> removed = new HashSet<String>(4);
                for (Object o : active) {
                    if (previouslyActive.contains(o)) continue;
                    added.add((String)o);
                }
                for (Object o : previouslyActive) {
                    if (active.contains(o)) continue;
                    removed.add((String)o);
                }
                EditorRegistry.this.contextChange(added, removed);
            }
        }
    };

    public static synchronized IEditorRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EditorRegistry();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    private EditorRegistry() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, EP_NAME);
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
        this.hookListeners();
    }

    private void close() {
        this.unhookListeners();
        this.tracker.close();
        this.tracker = null;
        this.editorMapping.clear();
        this.extensions = null;
        this.idToExtension = null;
        this.groupMap = null;
        this.adapterCache = null;
        this.cacheQueue = null;
    }

    private boolean containsAny(Collection<String> c, Collection<String> anyOf) {
        if (anyOf.isEmpty()) {
            return false;
        }
        for (String s : anyOf) {
            if (!c.contains(s)) continue;
            return true;
        }
        return false;
    }

    private void contextChange(Collection<String> added, Collection<String> removed) {
        if (!added.isEmpty()) {
            this.activeContextIds.addAll(added);
        }
        if (!removed.isEmpty()) {
            this.activeContextIds.remove(removed);
        }
        if (this.containsAny(this.referencedContextIds, added) || this.containsAny(this.referencedContextIds, removed)) {
            this.clearCache();
        }
    }

    private void hookListeners() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IContextService contextService = (IContextService)wb.getService(IContextService.class);
        contextService.addContextManagerListener(this.contextListener);
        this.activeContextIds = new HashSet<String>(contextService.getActiveContextIds());
    }

    private void unhookListeners() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IContextService contextService = (IContextService)wb.getService(IContextService.class);
        if (contextService != null) {
            contextService.removeContextManagerListener(this.contextListener);
        }
    }

    private String[] parseInContexts(IConfigurationElement parent) {
        ArrayList<String> contexts = null;
        IConfigurationElement[] iConfigurationElementArray = parent.getChildren(EL_NAME_IN_CONTEXT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            String id = el.getAttribute(ATTR_ID);
            if (id != null) {
                if (contexts == null) {
                    contexts = new ArrayList<String>(4);
                }
                contexts.add(id);
            }
            ++n2;
        }
        return contexts != null ? contexts.toArray(new String[contexts.size()]) : null;
    }

    private synchronized void loadExtensions(IConfigurationElement[] elements) {
        org.eclipse.ui.IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        HashSet<EditorAdapterDescriptorImpl> newExtensions = new HashSet<EditorAdapterDescriptorImpl>(Arrays.asList(this.extensions));
        HashMap<String, Group> newGroups = new HashMap<String, Group>();
        HashSet<String> newReferencedContextIds = new HashSet<String>(this.referencedContextIds);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block25: {
                IConfigurationElement el = iConfigurationElementArray[n2];
                String name = el.getName();
                try {
                    String id = el.getAttribute(ATTR_ID);
                    String groupId = el.getAttribute(ATTR_GROUP_ID);
                    EditorAdapter adapter = null;
                    String priority = el.getAttribute(ATTR_PRIORITY);
                    int pri = 0;
                    try {
                        if (priority != null && !priority.trim().isEmpty()) {
                            pri = Integer.parseInt(priority);
                        }
                    }
                    catch (NumberFormatException e) {
                        ExceptionUtils.logError((String)("Non-integer priority value '" + priority + "' for '" + name + "' extension contributed by '" + el.getDeclaringExtension().getContributor().getName() + "'"), (Throwable)e);
                    }
                    String[] inContexts = null;
                    if (EL_NAME_GROUP.equals(name)) {
                        if (id == null || id.isEmpty()) {
                            ExceptionUtils.logWarning((String)("A group extension contributed by " + el.getDeclaringExtension().getContributor().getName() + " does not define a required id."), null);
                        } else if (!newGroups.containsKey(id)) {
                            newGroups.put(id, new Group(id));
                        }
                        break block25;
                    }
                    if (EL_NAME_ADAPTER.equals(name)) {
                        String editorId = el.getAttribute(ATTR_EDITOR_ID);
                        IEditorDescriptor editorDesc = editorRegistry.findEditor(editorId);
                        if (editorDesc == null) {
                            ExceptionUtils.logError((String)("Non-existent editorId '" + editorId + "' in extension contributed by '" + el.getDeclaringExtension().getContributor().getName() + "'"), null);
                            break block25;
                        }
                        String type_uris = OntologyVersions.getInstance().currentVersion(el.getAttribute(ATTR_TYPE_URIS));
                        String[] typeUris = type_uris != null ? type_uris.split(",") : new String[]{};
                        String label = el.getAttribute(ATTR_LABEL);
                        String image = el.getAttribute(ATTR_IMAGE);
                        ImageDescriptor imageDesc = null;
                        if (label == null) {
                            label = editorDesc.getLabel();
                        }
                        if (image != null) {
                            try {
                                URL resolved = FileLocator.resolve((URL)new URL(image));
                                imageDesc = ImageDescriptor.createFromURL((URL)resolved);
                            }
                            catch (IOException iOException) {
                                Bundle bundle = Platform.getBundle((String)el.getDeclaringExtension().getContributor().getName());
                                imageDesc = ImageDescriptor.createFromURL((URL)bundle.getEntry(image));
                            }
                        } else {
                            imageDesc = editorDesc.getImageDescriptor();
                        }
                        SimpleEditorAdapter _adapter = new SimpleEditorAdapter(label, imageDesc, editorId, null, typeUris);
                        _adapter.setPriority(pri);
                        adapter = _adapter;
                        inContexts = this.parseInContexts(el);
                    } else if (EL_NAME_ADAPTERCLASS.equals(name)) {
                        adapter = (EditorAdapter)el.createExecutableExtension(ATTR_CLASS);
                        if (adapter instanceof Prioritized) {
                            ((Prioritized)((Object)adapter)).setPriority(pri);
                        }
                        inContexts = this.parseInContexts(el);
                    }
                    if (adapter != null) {
                        EditorAdapterDescriptorImpl ext = new EditorAdapterDescriptorImpl(id, groupId, adapter, inContexts);
                        this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                        if (id != null && !id.isEmpty()) {
                            this.idToExtension.put(id, ext);
                        }
                        if (inContexts != null) {
                            String[] stringArray = inContexts;
                            int n3 = inContexts.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String ctx = stringArray[n4];
                                newReferencedContextIds.add(ctx);
                                ++n4;
                            }
                        }
                        newExtensions.add(ext);
                    }
                }
                catch (CoreException e) {
                    ExceptionUtils.logError((String)("Failed to initialize resourceEditorAdapter extension \"" + name + "\": " + e.getMessage()), (Throwable)e);
                }
            }
            ++n2;
        }
        for (EditorAdapterDescriptorImpl desc : this.idToExtension.values()) {
            Group g;
            if (desc.getGroupId() == null || (g = (Group)newGroups.get(desc.getGroupId())) == null) continue;
            g.add(desc);
        }
        this.clearCache();
        this.extensions = newExtensions.toArray(new EditorAdapterDescriptorImpl[newExtensions.size()]);
        this.groupMap = newGroups;
        this.referencedContextIds = newReferencedContextIds;
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public synchronized void removeExtension(IExtension extension, Object[] objects) {
        HashSet<EditorAdapterDescriptorImpl> newExtensions = new HashSet<EditorAdapterDescriptorImpl>(Arrays.asList(this.extensions));
        HashMap<String, EditorAdapterDescriptorImpl> idMap = new HashMap<String, EditorAdapterDescriptorImpl>(this.idToExtension);
        HashSet<String> removedContextReferences = new HashSet<String>();
        HashMap<String, Group> newGroups = new HashMap<String, Group>();
        for (Group g : this.groupMap.values()) {
            newGroups.put(g.id, new Group(g));
        }
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Group g;
            Object o = objectArray[n2];
            EditorAdapterDescriptor ext = (EditorAdapterDescriptor)o;
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove(ext);
            idMap.remove(ext.getId());
            if (ext.getGroupId() != null && (g = (Group)newGroups.get(ext.getGroupId())) != null) {
                g.remove(ext);
            }
            for (String ctx : ext.getInContexts()) {
                removedContextReferences.add(ctx);
            }
            ++n2;
        }
        for (EditorAdapterDescriptorImpl desc : newExtensions) {
            for (String ctx : desc.getInContexts()) {
                removedContextReferences.remove(ctx);
            }
        }
        HashSet<String> newReferencedContextIds = new HashSet<String>(this.referencedContextIds);
        newReferencedContextIds.removeAll(removedContextReferences);
        this.extensions = newExtensions.toArray(new EditorAdapterDescriptorImpl[newExtensions.size()]);
        this.idToExtension = idMap;
        this.groupMap = newGroups;
        this.referencedContextIds = newReferencedContextIds;
    }

    @Override
    public EditorAdapterDescriptor getExtensionById(String id) {
        return this.idToExtension.get(id);
    }

    @Override
    public EditorAdapter getAdapterById(String id) {
        EditorAdapterDescriptor ext = this.idToExtension.get(id);
        return ext == null ? null : ext.getAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        WeakHashMap<Object, EditorAdapter[]> weakHashMap = this.adapterCache;
        synchronized (weakHashMap) {
            this.adapterCache.clear();
            this.cacheQueue.clear();
        }
    }

    @Override
    public EditorAdapterDescriptor[] getEditorAdapters() {
        return this.extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EditorAdapter[] getAdaptersFor(ReadGraph g, Object r) throws DatabaseException {
        EditorAdapter[] result;
        WeakHashMap<Object, EditorAdapter[]> weakHashMap = this.adapterCache;
        synchronized (weakHashMap) {
            result = this.adapterCache.get(r);
            if (result != null) {
                return result;
            }
        }
        MultiStatus status = null;
        MapList l = new MapList();
        EditorAdapterDescriptorImpl[] editorAdapterDescriptorImplArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            EditorAdapterDescriptorImpl a = editorAdapterDescriptorImplArray[n2];
            try {
                if (a.isActive(this.activeContextIds) && a.getAdapter().canHandle(g, r)) {
                    l.add((Object)a.getGroupId(), (Object)a.getAdapter());
                }
            }
            catch (RuntimeException e) {
                if (status == null) {
                    status = new MultiStatus(NAMESPACE, 0, "Unexpected errors occured in EditorAdapters:", null);
                }
                status.add((IStatus)new Status(4, NAMESPACE, e.getMessage(), (Throwable)e));
            }
            ++n2;
        }
        Resource res = ResourceAdaptionUtils.toSingleResource(r);
        if (res != null) {
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
            Resource indexRoot = (Resource)g.syncRequest((Read)new PossibleIndexRoot(res));
            if (indexRoot != null) {
                Instances query = (Instances)g.adapt(MOD.EditorContribution, Instances.class);
                for (Resource contribution : query.find(g, indexRoot)) {
                    try {
                        String id = (String)g.getRelatedValue(contribution, MOD.EditorContribution_editorId, (Binding)Bindings.STRING);
                        String label = NameUtils.getSafeLabel((ReadGraph)g, (Resource)contribution);
                        Resource imageResource = g.getPossibleObject(contribution, MOD.EditorContribution_HasImage);
                        ImageDescriptor image = imageResource == null ? null : (ImageDescriptor)g.adapt(imageResource, ImageDescriptor.class);
                        Integer priority = (Integer)g.getRelatedValue(contribution, MOD.EditorContribution_priority, (Binding)Bindings.INTEGER);
                        GraphEditorAdapterDescriptor a = new GraphEditorAdapterDescriptor(id, label, image, contribution, priority);
                        if (!a.isActive(this.activeContextIds) || !a.getAdapter().canHandle(g, r)) continue;
                        l.add((Object)a.getGroupId(), (Object)a.getAdapter());
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            }
        }
        result = this.gatherAdapterResult((MapList<String, EditorAdapter>)l);
        Arrays.sort(result, ADAPTER_COMPARATOR);
        this.updateCache(r, result);
        if (status != null && !status.isOK()) {
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return result;
    }

    private EditorAdapter[] gatherAdapterResult(MapList<String, EditorAdapter> map) {
        ArrayList<EditorAdapter> result = new ArrayList<EditorAdapter>(8);
        for (String group : map.getKeys()) {
            List grp = map.getValues((Object)group);
            if (group == null) {
                if (grp == null) continue;
                result.addAll(grp);
                continue;
            }
            EditorAdapter highestPriorityAdapter = null;
            for (EditorAdapter adapter : grp) {
                if (highestPriorityAdapter != null && adapter.getPriority() <= highestPriorityAdapter.getPriority()) continue;
                highestPriorityAdapter = adapter;
            }
            result.add(highestPriorityAdapter);
        }
        return result.toArray(EMPTY_ADAPTER_ARRAY);
    }

    @Override
    public EditorMapping getMappings() {
        return this.editorMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache(Object r, EditorAdapter[] result) {
        WeakHashMap<Object, EditorAdapter[]> weakHashMap = this.adapterCache;
        synchronized (weakHashMap) {
            this.adapterCache.put(r, result);
            Object removed = this.cacheQueue.write(r);
            if (removed != null) {
                this.adapterCache.remove(removed);
            }
        }
    }

    @Override
    public EditorAdapter[] getDefaultAdaptersFor(ReadGraph g, Object r) throws DatabaseException {
        MultiStatus status = null;
        MapList l = new MapList();
        EditorAdapterDescriptorImpl[] editorAdapterDescriptorImplArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            EditorAdapterDescriptorImpl a = editorAdapterDescriptorImplArray[n2];
            try {
                l.add((Object)a.getGroupId(), (Object)a.getAdapter());
            }
            catch (RuntimeException e) {
                if (status == null) {
                    status = new MultiStatus(NAMESPACE, 0, "Unexpected errors occured in EditorAdapters:", null);
                }
                status.add((IStatus)new Status(4, NAMESPACE, e.getMessage(), (Throwable)e));
            }
            ++n2;
        }
        EditorAdapter[] results = this.gatherAdapterResult((MapList<String, EditorAdapter>)l);
        if (status != null && !status.isOK()) {
            Activator.getDefault().getLog().log(status);
        }
        if (results.length > 0) {
            return results;
        }
        return this.getAdaptersFor(g, r);
    }

    private static class CircularBuffer<T> {
        private final WeakReference<?>[] buffer;
        private int head;
        private int tail;
        private boolean full;
        private final int size;

        CircularBuffer(int size) {
            if (size == 0) {
                throw new IllegalArgumentException("zero size not allowed");
            }
            this.buffer = new WeakReference[size];
            this.size = size;
            this.clear();
        }

        public void clear() {
            this.tail = 0;
            this.head = 0;
            this.full = false;
            Arrays.fill(this.buffer, null);
        }

        T write(T id) {
            if (id == null) {
                throw new IllegalArgumentException("null resource id");
            }
            if (this.full) {
                WeakReference<?> prev = this.buffer[this.head];
                this.buffer[this.head++] = new WeakReference<T>(id);
                this.head %= this.size;
                this.tail = this.head;
                return prev.get();
            }
            this.buffer[this.head++] = new WeakReference<T>(id);
            this.head %= this.size;
            if (this.head == this.tail) {
                this.full = true;
            }
            return null;
        }

        public String toString() {
            return Arrays.toString(this.buffer);
        }
    }

    private static class Group {
        public final String id;
        public final List<EditorAdapterDescriptor> adapters;

        Group(String id) {
            this.id = id;
            this.adapters = new ArrayList<EditorAdapterDescriptor>();
        }

        Group(Group g) {
            this.id = g.id;
            this.adapters = new ArrayList<EditorAdapterDescriptor>(g.adapters);
        }

        void add(EditorAdapterDescriptor desc) {
            this.adapters.add(desc);
        }

        void remove(EditorAdapterDescriptor desc) {
            this.adapters.remove(desc);
        }
    }
}

