/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.e4;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.ListenerAdapter;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.e4.E4ResourceEditorBase;
import org.simantics.ui.workbench.e4.E4WorkbenchUtils;
import org.simantics.utils.datastructures.map.Tuple;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.SWTUtils;

public class E4ResourceEditorSupport {
    private E4ResourceEditorBase editor;
    private ParametrizedRead<IResourceEditorInput, Boolean> inputValidator;
    private InputListener inputListener;

    public E4ResourceEditorSupport(E4ResourceEditorBase editor) {
        this(editor, null);
    }

    public E4ResourceEditorSupport(E4ResourceEditorBase editor, ParametrizedRead<IResourceEditorInput, Boolean> inputValidator) {
        this.editor = editor;
        this.inputValidator = inputValidator;
    }

    public void dispose() {
        this.deactivateValidation();
        this.inputValidator = null;
        this.editor = null;
    }

    protected boolean isDisposed() {
        return this.editor == null;
    }

    public synchronized void activateValidation() {
        if (this.isDisposed()) {
            throw new IllegalStateException(this + " is disposed");
        }
        if (this.inputListener != null) {
            return;
        }
        E4ResourceEditorBase e = this.editor;
        this.inputListener = new InputListener();
        Simantics.getSession().asyncRequest((Read)new InputEvaluator(e.getPart().getElementId(), e.getResourceInput(), this.inputValidator), (Listener)this.inputListener);
    }

    public synchronized void deactivateValidation() {
        if (this.isDisposed()) {
            throw new IllegalStateException(this + " is disposed");
        }
        if (this.inputListener == null) {
            return;
        }
        this.inputListener.dispose();
    }

    private static void scheduleEditorClose(String editorElementId) {
        SWTUtils.asyncExec((Display)PlatformUI.getWorkbench().getDisplay(), () -> E4WorkbenchUtils.closeEditor(editorElementId));
    }

    static class Evaluation
    extends Tuple {
        public Evaluation(String editorElementId, InputState state) {
            super(new Object[]{editorElementId, state});
        }

        public String getEditorElementId() {
            return (String)this.getField(0);
        }

        public InputState getInputState() {
            return (InputState)((Object)this.getField(1));
        }
    }

    public static class InputEvaluator
    extends TernaryRead<String, IResourceEditorInput, ParametrizedRead<IResourceEditorInput, Boolean>, Evaluation> {
        public InputEvaluator(String editorElementId, IResourceEditorInput input, ParametrizedRead<IResourceEditorInput, Boolean> inputValidator) {
            super((Object)editorElementId, (Object)input, inputValidator);
        }

        public Evaluation perform(ReadGraph graph) throws DatabaseException {
            IResourceEditorInput i = (IResourceEditorInput)this.parameter2;
            boolean exists = i.exists(graph);
            boolean valid = exists && this.parameter3 != null ? (Boolean)graph.syncRequest(((ParametrizedRead)this.parameter3).get((Object)i)) : exists;
            InputState state = InputState.parse(exists, valid);
            Evaluation eval = new Evaluation((String)this.parameter, state);
            return eval;
        }
    }

    private static class InputListener
    extends ListenerAdapter<Evaluation> {
        private boolean disposed = false;

        private InputListener() {
        }

        public void dispose() {
            this.disposed = true;
        }

        public void execute(Evaluation evaluation) {
            switch (evaluation.getInputState()) {
                case VALID: {
                    break;
                }
                case INVALID: 
                case NON_EXISTENT: {
                    E4ResourceEditorSupport.scheduleEditorClose(evaluation.getEditorElementId());
                }
            }
        }

        public void exception(Throwable t) {
            ExceptionUtils.logError((String)"E4ResourceEditorSupport.InputListener received an unexpected exception.", (Throwable)t);
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }

    static enum InputState {
        VALID,
        INVALID,
        NON_EXISTENT;


        public static InputState parse(boolean exists, boolean valid) {
            if (!exists) {
                return NON_EXISTENT;
            }
            return valid ? VALID : INVALID;
        }
    }
}

