/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.util.List;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.ui.workbench.IPerspectiveContextExtension;
import org.simantics.ui.workbench.PerspectiveContextBindingManager;
import org.simantics.utils.datastructures.MapList;

public class PerspectiveContextActivator
implements IPerspectiveListener4,
IWindowListener {
    private IWorkbenchWindow activeWindow;
    private String oldPerspective;
    private MapList<String, IContextActivation> activations = new MapList();

    public PerspectiveContextActivator() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
    }

    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.activatePerspective(perspective.getId());
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.attachToWindow(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
        this.detachFromWindow(window);
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    private void attachToWindow(IWorkbenchWindow window) {
        this.activeWindow = window;
        window.addPerspectiveListener((IPerspectiveListener)this);
        IPerspectiveDescriptor perspective = window.getActivePage().getPerspective();
        if (perspective != null) {
            this.activatePerspective(perspective.getId());
        }
    }

    private void detachFromWindow(IWorkbenchWindow window) {
        window.removePerspectiveListener((IPerspectiveListener)this);
    }

    private IContextService getService(IWorkbenchWindow window) {
        return (IContextService)window.getWorkbench().getService(IContextService.class);
    }

    private IContextActivation activate(String ctx) {
        IContextService contextService = this.getService(this.activeWindow);
        if (contextService != null && ctx != null) {
            IContextActivation act = contextService.activateContext(ctx);
            return act;
        }
        return null;
    }

    private void deactivate(IContextActivation activation) {
        IContextService contextService = this.getService(this.activeWindow);
        if (contextService != null && activation != null) {
            contextService.deactivateContext(activation);
        }
    }

    private void activatePerspective(String perspectiveId) {
        if (this.oldPerspective != null) {
            if (this.oldPerspective.equals(perspectiveId)) {
                return;
            }
            List acts = this.activations.getValues((Object)this.oldPerspective);
            if (acts != null) {
                this.activations.remove((Object)this.oldPerspective);
                for (IContextActivation act : acts) {
                    this.deactivate(act);
                }
            }
        }
        List<IPerspectiveContextExtension> exts = PerspectiveContextBindingManager.getInstance().getExtensions(perspectiveId);
        for (IPerspectiveContextExtension ext : exts) {
            String[] stringArray = ext.getContextIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ctx = stringArray[n2];
                IContextActivation activation = this.activate(ctx);
                if (activation != null) {
                    this.activations.add((Object)perspectiveId, (Object)activation);
                }
                ++n2;
            }
        }
        this.oldPerspective = perspectiveId;
    }
}

