/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.jobs;

import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SessionGarbageCollection;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.ui.ErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionGarbageCollectorJob
extends Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionGarbageCollectorJob.class);
    private static SessionGarbageCollectorJob instance;
    private static final boolean TRACE = false;
    private static final long DEFAULT_QUIET_TIME = 5000L;
    private long start;
    private long quietTime;
    private long userDefinedQuietTime;
    private boolean enabled = true;
    Consumer<DatabaseException> errorCallback = e -> ErrorLogger.defaultLogError((Throwable)e);

    public static synchronized SessionGarbageCollectorJob getInstance() {
        if (instance == null) {
            instance = new SessionGarbageCollectorJob();
        }
        return instance;
    }

    public SessionGarbageCollectorJob() {
        this(5000L);
    }

    public SessionGarbageCollectorJob(long delayBetweenExecutions) {
        super("Database Garbage Collector");
        this.setPriority(50);
        this.setSystem(true);
        this.start = System.currentTimeMillis();
        this.quietTime = delayBetweenExecutions;
        this.userDefinedQuietTime = delayBetweenExecutions;
    }

    public void rescheduleAfterQuietTime() {
        this.cancel();
        this.scheduleAfterQuietTime();
    }

    public void rescheduleNow() {
        this.cancel();
        this.schedule();
    }

    public SessionGarbageCollectorJob setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void scheduleAfterQuietTime() {
        this.schedule(this.quietTime);
    }

    public boolean shouldSchedule() {
        return this.enabled;
    }

    public boolean shouldRun() {
        return this.enabled;
    }

    protected IStatus run(IProgressMonitor monitor) {
        long interval = this.quietTime;
        try {
            Session session = Simantics.peekSession();
            if (session == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            LifecycleSupport lfs = (LifecycleSupport)session.peekService(LifecycleSupport.class);
            if (lfs == null || lfs.isClosed() || lfs.isClosing()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (DatabaseJob.inProgress()) {
                interval = Math.min(10L, this.quietTime);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            long begin = System.currentTimeMillis();
            boolean busy = SessionGarbageCollection.gc((IProgressMonitor)monitor, (Session)session, (boolean)true, this.errorCallback);
            if (busy) {
                this.quietTime = Math.max(3L * this.quietTime / 4L, 100L);
            } else if (this.quietTime < this.userDefinedQuietTime) {
                this.quietTime = Math.min(this.userDefinedQuietTime, (long)(1.2 * (double)this.quietTime));
            }
            interval = this.quietTime;
            long intermediate = System.currentTimeMillis();
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.schedule(interval);
            monitor.done();
        }
    }
}

