/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.auth;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.simantics.ui.auth.model.LoginModel;

public class LoginComposite
extends Composite {
    private LoginModel model;

    public LoginComposite(Composite parent, int style, LoginModel m) {
        super(parent, style);
        this.model = m;
        LoginComposite body = this;
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(2).applyTo((Composite)body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        Label desc = new Label((Composite)this, 0);
        desc.setText("Enter credentials for " + this.model.getServer().getInfo());
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)desc);
        Label nameLabel = new Label((Composite)this, 0);
        nameLabel.setText("&User name:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)nameLabel);
        final Text nameText = new Text((Composite)this, 2048);
        nameText.setText(this.model.getName());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameText);
        Label passwordLabel = new Label((Composite)this, 0);
        passwordLabel.setText("&Password:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)passwordLabel);
        final Text passwordText = new Text((Composite)this, 0x400800);
        passwordText.setText(this.model.getPassword());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)passwordText);
        final Button rememberButton = new Button((Composite)this, 32);
        rememberButton.setText("&Remember Login");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)rememberButton);
        Label separator = new Label((Composite)this, 258);
        GridDataFactory.fillDefaults().align(4, 1024).span(2, 1).grab(false, true).applyTo((Control)separator);
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginComposite.this.model.setName(nameText.getText());
            }
        });
        passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginComposite.this.model.setPassword(passwordText.getText());
            }
        });
        rememberButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginComposite.this.model.setRemember(rememberButton.getSelection());
            }
        });
        new FocusSelector(nameText);
        new FocusSelector(passwordText);
    }

    public void dispose() {
        if (this.isDisposed()) {
            super.dispose();
        }
    }

    static class FocusSelector
    implements FocusListener {
        Text text;

        FocusSelector(Text text) {
            this.text = text;
            text.addFocusListener((FocusListener)this);
        }

        public void focusGained(FocusEvent e) {
            this.text.selectAll();
        }

        public void focusLost(FocusEvent e) {
            this.text.setSelection(0);
        }
    }
}

