/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class AbstractPreferenceHandler extends AbstractHandler {

    private AbstractUIPlugin plugin;

    public AbstractPreferenceHandler(AbstractUIPlugin plugin) {
        Assert.isNotNull(plugin);
        this.plugin = plugin;
    }

    protected IPreferenceStore getPrefs() {
        return plugin.getPreferenceStore();
    }

    protected void savePrefs() {
        plugin.savePluginPreferences();
    }

    protected String getPreferenceString(String key) {
        return getPrefs().getString(key);
    }

    protected void setPreference(String key, String value) {
        getPrefs().setValue(key, value);
    }

}
