/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;
import org.simantics.ui.dialogs.ActionChooserDialog;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.utils.ui.action.IPriorityAction;


/**
 * @author Tuukka Lehtonen
 */
public class OpenWithDialogAction extends Action {

    Shell             shell;
    String            description;
    IPriorityAction[] actions;

    public OpenWithDialogAction(Shell parent, EditorAdapter[] adapters, Resource r) {
        super("Open With...");
        this.shell = parent;
        this.description = "Open with:";
        this.actions = ResourceEditorAdapterAction.toActions(adapters, r);
    }

    @Override
    public void run() {
        ActionChooserDialog dialog = new ActionChooserDialog(shell, actions, "Choose Editor", description);
        dialog.open();
        IAction a = dialog.getChosenAction();
        if (a != null) {
            a.run();
        }
    }

}
