/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.eclipse.ui.IEditorInput;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.project.IProjectService;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * An IProject service for naming editors while working on a project.
 * 
 * @author Tuukka Lehtonen
 */
public interface IEditorNamingService extends IProjectService {

    /**
     * This key is used with an IProject for storing an
     * {@link IEditorNamingService} in it. If this hint exists in the project,
     * then the project has its own way of naming editors and it should be used
     * by editors to initialize their titles.
     */
    Key KEY_EDITOR_NAMING_SERVICE = new KeyOf(IEditorNamingService.class);

    /**
     * Get the name that should be shown on an editor with the specified id and
     * the specified input.
     * 
     * @param graph a graph for reading information for constructing a name
     * @param editorId the ID of the editor to be named
     * @param input the input of the editor to be named
     * @return the service-preferred name for the editor
     * @throws DatabaseException on any errors that occur while reading the
     *         graph
     */
    String getName(ReadGraph graph, String editorId, IEditorInput input) throws DatabaseException;

}
