/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.tester;

import java.util.Arrays;

import org.eclipse.core.expressions.PropertyTester;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.management.ISessionContext;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class CollectionResourcePropertyTester extends PropertyTester {

    private static final boolean DEBUG = false;

    /**
     * Tests if the received resource is an instance of any of the URIs
     * listed in the arguments.
     */
    protected static final String RESOURCE_TYPES = "resourceTypes";

    private static final OntologyVersions VERSIONS = OntologyVersions.getInstance();
    
    @Override
    public boolean test(final Object receiver, final String property, final Object[] args, final Object expectedValue) {
        if (DEBUG)
            System.out.println("TEST: " + receiver + ", " + property + ", " + Arrays.toString(args) + ", " + expectedValue);

        final Resource[] resources = ResourceAdaptionUtils.toResources(receiver);
        if (resources == null)
            return false;

        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null)
            return false;

        if (DatabaseJob.inProgress())
            return false;

        try {
            return RequestUtil.trySyncRequest(
                    ctx.getSession(),
                    SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT,
                    SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT,
                    false,
                    new UniqueRead<Boolean>() {
                @Override
                public Boolean perform(ReadGraph g) throws DatabaseException {
                    return Boolean.valueOf(doTest(g, resources, property, args, expectedValue));
                }
            });
        } catch (DatabaseException | InterruptedException e) {
            // Purposefully not logging these exceptions, there might be way too
            // many even under normal circumstances.
            // TODO: add debug tracing options controlling the printing of these exceptions
            return false;
        }
    }

    protected boolean doTest(ReadGraph g, Resource[] resources, String property, Object[] args, Object expectedValue) throws DatabaseException {
        if (RESOURCE_TYPES.equals(property)) {
        	loop: for(Resource r : resources) {
        		if (DEBUG)
        			System.out.println("** " + NameUtils.getSafeName(g, r));
        		try {
        			for (int i = 0; i < args.length; i++) {
        				if (g.isInstanceOf(r, g.getResource(VERSIONS.currentVersion((String) args[i])))) {
        					if (DEBUG)
        						System.out.println("IS INSTANCE OF " + args[i]);
        					continue loop;
        				}
        			}
        		} catch (ResourceNotFoundException e) {
        			/* This is a natural situation (database does not contain all resources
                   referred in plugins). No error reporting.
        			 */
        			return false;
        		}
        		if (DEBUG)
        			System.out.println("NOT AN INSTANCE OF ANY OF: " + Arrays.toString(args));
        		return false;
        	}
            return true;
        }
        return false;
    }

}
