/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.colors;

import org.eclipse.swt.graphics.RGB;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.ResourceAdapter;
import org.simantics.db.procedure.AsyncProcedure;

public class RGBAdapter implements ResourceAdapter<RGB> {

    public static class RGBDouble {
        public double red;
        public double green;
        public double blue;
    }

    public static final Binding BINDING = Bindings.getBindingUnchecked(RGBDouble.class);

    @Override
    public void adapt(AsyncReadGraph g, Resource source, Resource r, final AsyncProcedure<RGB> procedure) {
        g.forValue(r, BINDING, new AsyncProcedure<RGBDouble>() {
            @Override
            public void execute(AsyncReadGraph graph, RGBDouble result) {
                procedure.execute(graph, 
                        new RGB(
                                (int)(result.red*255.0),
                                (int)(result.green*255.0),
                                (int)(result.blue*255.0)
                        )
                );
            }

            @Override
            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

}
