/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.impl;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.trend.impl.TrendLayout;
import org.simantics.trend.impl.TrendNode;

public abstract class TrendGraphicalNode
extends G2DNode
implements TrendLayout {
    private static final long serialVersionUID = 1L;
    Rectangle2D bounds = new Rectangle2D.Double();

    public double getWidth() {
        return this.bounds.getWidth();
    }

    public double getHeight() {
        return this.bounds.getHeight();
    }

    public void setSize(double w, double h) {
        if (this.bounds.getWidth() == w && this.bounds.getHeight() == h) {
            return;
        }
        this.bounds.setFrame(0.0, 0.0, w, h);
    }

    public double getX() {
        return this.transform.getTranslateX();
    }

    public double getY() {
        return this.transform.getTranslateY();
    }

    public void setTranslate(double x, double y) {
        this.setTransform(AffineTransform.getTranslateInstance(x, y));
    }

    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    public void render(Graphics2D g2d) {
        AffineTransform at = g2d.getTransform();
        g2d.transform(this.transform);
        try {
            this.doRender(g2d);
        }
        finally {
            g2d.setTransform(at);
        }
    }

    public TrendNode getTrend() {
        return (TrendNode)this.getParent();
    }

    protected abstract void doRender(Graphics2D var1);
}

