/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.text.Format;
import java.text.NumberFormat;
import org.simantics.g2d.utils.GridSpacing;
import org.simantics.g2d.utils.GridUtil;
import org.simantics.trend.configuration.TimeFormat;
import org.simantics.trend.configuration.TimeWindow;
import org.simantics.trend.configuration.TrendSpec;
import org.simantics.trend.impl.ItemNode;
import org.simantics.trend.impl.TrendGraphicalNode;
import org.simantics.trend.impl.TrendNode;

public class HorizRuler
extends TrendGraphicalNode {
    private static final long serialVersionUID = 7155812928124259094L;
    GridSpacing spacing = GridSpacing.SOME_SPACING;
    public double from = 0.0;
    public double end = 100.0;
    public boolean autoscroll = true;
    boolean manualscale = false;
    org.simantics.utils.format.TimeFormat timeFormat = new org.simantics.utils.format.TimeFormat(0.0, 0);
    private Format f = this.timeFormat;
    double iFrom = Double.MAX_VALUE;
    double iEnd = -1.7976931348623157E308;
    public double basetime = 0.0;
    public TimeWindowListener listener;
    public static final Color AUTOSCROLL_ON = new Color(0, 225, 34);
    public static final Color AUTOSCROLL_OFF = new Color(255, 115, 115);

    public boolean setWidth(double width) {
        if (this.getWidth() == width) {
            return false;
        }
        this.setSize(width, 20.0);
        return true;
    }

    public boolean setFromEnd(double from, double end) {
        if (this.from != from || this.end != end) {
            this.from = from;
            this.end = end;
            this.getTrend().shapedirty = true;
            return true;
        }
        return false;
    }

    public boolean setFromScale(double from, double scaleX) {
        double end = this.getWidth() * scaleX + from;
        return this.setFromEnd(from, end);
    }

    public void fireListener() {
        if (this.listener != null) {
            double wid = this.getWidth();
            if (wid == 0.0) {
                wid = 0.1;
            }
            double sx = (this.end - this.from) / wid;
            this.listener.onNewWindow(this.from, this.end, sx);
        }
    }

    public void layout() {
        TrendNode trend = this.getTrend();
        if (trend.timeFormat == TimeFormat.Time) {
            this.timeFormat.setMaxValue(this.end);
            this.timeFormat.setDecimals(1);
            double labelWidth = 0.0;
            double maxLabelWidth = 0.0;
            int i = 0;
            while (i < 2) {
                labelWidth = GridUtil.calcLabelWidth((double)(this.from - this.basetime), (double)(this.end - this.basetime), (Format)this.timeFormat, (GridSpacing)this.spacing);
                maxLabelWidth = Math.max(labelWidth, maxLabelWidth);
                this.spacing = GridSpacing.makeGridSpacing((double)(this.end - this.from), (double)this.getWidth(), (double)(labelWidth + 10.0));
                this.timeFormat.setDecimals((int)(-this.spacing.segmentExp));
                ++i;
            }
            if (maxLabelWidth > labelWidth) {
                this.spacing = GridSpacing.makeGridSpacing((double)(this.end - this.from), (double)this.getWidth(), (double)(maxLabelWidth + 10.0));
                this.timeFormat.setDecimals((int)(-this.spacing.segmentExp));
            }
            this.f = this.timeFormat;
        } else {
            this.f = NumberFormat.getInstance();
            double labelWidth = GridUtil.calcLabelWidth((double)(this.from - this.basetime), (double)this.end, (Format)this.f, (GridSpacing)this.spacing);
            this.spacing = GridSpacing.makeGridSpacing((double)(this.end - this.from), (double)this.getWidth(), (double)(labelWidth + 10.0));
        }
    }

    @Override
    protected void doRender(Graphics2D g2d) {
        TrendNode trend = this.getTrend();
        if (!trend.printing) {
            g2d.setColor(this.autoscroll ? AUTOSCROLL_ON : AUTOSCROLL_OFF);
            g2d.setFont(GridUtil.RULER_FONT);
            String txt = !this.autoscroll ? (this.manualscale ? "*" : "Auto-scroll off") : (this.manualscale ? "" : "Auto-scroll on");
            g2d.drawString(txt, (float)this.getWidth() + 20.0f, 20.0f);
        }
        g2d.setPaint(Color.GRAY);
        g2d.setStroke(GridUtil.RULER_LINE_STROKE);
        GridUtil.paintHorizontalRuler((GridSpacing)this.spacing, (Graphics2D)g2d, (double)(this.from - this.basetime), (double)this.getWidth(), (Format)this.f);
    }

    public void setKnownFromEnd() {
        TrendNode trendNode = (TrendNode)this.getParent();
        this.iFrom = Double.MAX_VALUE;
        this.iEnd = -1.7976931348623157E308;
        for (ItemNode item : trendNode.allItems) {
            if (!Double.isNaN(item.from)) {
                this.iFrom = Math.min(this.iFrom, item.from);
            }
            if (Double.isNaN(item.end)) continue;
            this.iEnd = Math.max(this.iEnd, item.end);
        }
        if (this.iFrom == Double.MAX_VALUE && this.iEnd == -1.7976931348623157E308) {
            this.iFrom = 0.0;
            this.iEnd = 10.0;
        }
    }

    public boolean autoscale() {
        double len;
        if (!this.autoscroll) {
            return false;
        }
        this.setKnownFromEnd();
        TrendNode trendNode = (TrendNode)this.getParent();
        TrendSpec spec = trendNode.spec;
        double nFrom = this.from;
        double nEnd = this.end;
        TimeWindow timeWindow = spec.viewProfile.timeWindow;
        double d = len = timeWindow.timeWindowLength != null ? timeWindow.timeWindowLength : this.iEnd - this.iFrom;
        if (timeWindow.timeWindowStart != null) {
            if (timeWindow.timeWindowIncrement != null && timeWindow.timeWindowLength == null) {
                nFrom = timeWindow.timeWindowStart + this.basetime;
                if (nFrom > this.iEnd) {
                    nEnd = nFrom + 1.0;
                } else {
                    len = Math.max(0.0, this.iEnd - nFrom);
                    double f = (100.0 - timeWindow.timeWindowIncrement) / 100.0;
                    double b = 1.0 / f;
                    double x = Math.log(len) / Math.log(b);
                    x = Math.ceil(x);
                    x = Math.pow(b, x);
                    nEnd = nFrom + x;
                }
            } else {
                nFrom = timeWindow.timeWindowStart + this.basetime;
                nEnd = nFrom + len;
            }
        } else {
            if (timeWindow.timeWindowIncrement == null) {
                nFrom = this.iEnd - len;
                nEnd = this.iEnd;
                nEnd += len * 0.02;
            } else if (timeWindow.timeWindowLength != null) {
                double f = timeWindow.timeWindowIncrement / 100.0;
                double fraction = len * f;
                nEnd = Math.floor((this.iEnd + fraction) / fraction) * fraction;
                nFrom = nEnd - len;
                if (nFrom < this.iFrom) {
                    double diff = this.iFrom - nFrom;
                    nFrom += diff;
                    nEnd += diff;
                }
                if (Double.isInfinite(nEnd)) {
                    nFrom = 0.0;
                    nEnd = len;
                } else {
                    nEnd += len * 0.02;
                }
            } else {
                double f = (100.0 - timeWindow.timeWindowIncrement) / 100.0;
                double b = 1.0 / f;
                double x = Math.log(len) / Math.log(b);
                x = Math.ceil(x);
                x = Math.pow(b, x);
                nEnd = this.iFrom + x;
                nFrom = this.iFrom;
            }
            if (nFrom > nEnd) {
                nFrom = nEnd;
            }
        }
        return this.setFromEnd(nFrom, nEnd);
    }

    public void translate(double dx) {
        this.from += dx;
        this.end += dx;
        this.autoscroll = false;
        this.fireListener();
    }

    public double toTime(double x) {
        double sx = (this.end - this.from) / this.getWidth();
        return this.from + x * sx;
    }

    public double toX(double time) {
        double sx = (this.end - this.from) / this.getWidth();
        return (time - this.from) / sx;
    }

    public void zoomIn(double x, double width) {
        this.autoscroll = false;
        double sx = (this.end - this.from) / this.getWidth();
        double newFrom = this.from + x * sx;
        double newEnd = this.from + (x + width) * sx;
        this.from = newFrom;
        this.end = newEnd;
        this.fireListener();
    }

    public void zoomOut() {
        this.autoscroll = true;
        this.autoscale();
        this.layout();
        this.fireListener();
    }

    public double unitsPerPixel() {
        return (this.end - this.from) / this.getWidth();
    }

    public double getItemFromTime() {
        return this.iFrom;
    }

    public double getItemEndTime() {
        return this.iEnd;
    }

    public static interface TimeWindowListener {
        public void onNewWindow(double var1, double var3, double var5);
    }
}

