/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.impl;

import java.awt.Font;

import org.simantics.g2d.utils.GridUtil;

public interface TrendLayout {

    public static final Font RULER_FONT = GridUtil.RULER_FONT;    
    public static final Font RULER_FONT_BOLD = GridUtil.RULER_FONT_BOLD;    
	
	public static final double VERT_MARGIN = 10;
	public static final double HORIZ_MARGIN = 30;
	public static final double TITLE_HEIGHT = 40;
	public static final double TITLE_FONT = 30;
	public static final double MILESTONE_HEIGHT = 20;

	public static final double[] BINARY = new double[] {/*false y*/26., /*true y*/ 9., /*bottom y*/32., /*Height*/40.};
	public static final double BINARY_LABEL_WIDTH = 50;
	
	public static final double HORIZ_RULER_HEIGHT = 26;
	public static final double VERT_RULER_WIDTH = 55;
	public static final double MINOR_TICK = 4;
	public static final double MAJOR_TICK = 7;

	/**
	 * The pixel distance on both sides of the vertical value tip line that is
	 * still considered as hovering on top of the value tip line.
	 */
	public static final double VALUE_TIP_HOVER_SENSITIVITY = 3;

}
