/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.impl;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DNode;

public class SelectionNode extends G2DNode {
	
    private static final long serialVersionUID = -8803833805847402592L;

    public static AlphaComposite composite = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, .5f);
	public static final Color COLOR = new Color(.5f, .5f, 1.f);
    public static final BasicStroke STROKE =
            new BasicStroke(1.f,
                    BasicStroke.CAP_SQUARE,
                    BasicStroke.CAP_SQUARE,
                    10.0f, null, 0.0f);
    
    double x1, x2, y1, y2;
    Rectangle2D.Double rect = new Rectangle2D.Double(0, 0, 1, 1);
    Rectangle2D.Double rect2 = new Rectangle2D.Double(0, 0, 1, 1);
    boolean binaryZoom = false, timeZoom = false;
    
    public void start(Point2D pt, boolean binaryZoom, boolean timeZoom)
    {
    	x1 = x2 = pt.getX();
    	y1 = y2 = pt.getY();
    	rect.setFrame(x1, y1, 0, 0);	
    	rect2.setFrame(x1, y1, 0, 0);
    	this.binaryZoom = binaryZoom;
    	this.timeZoom = timeZoom;
    }
    
    public void setEndPoint(Point2D pt)
    {
    	x2 = pt.getX();
    	y2 = pt.getY();
    	layout();
    }
    
    public void layout() {
    	TrendNode trend = (TrendNode) getParent();
    	Plot plot = trend.plot;
    	
    	if (binaryZoom) {
    		// Binary Zoom
    		double px = plot.getX();
        	double py = plot.getY()+plot.analogAreaHeight;
        	double pw = plot.getWidth();
        	double ph = plot.binaryAreaHeight;
    		
        	rect2.setFrame( Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1-x2), Math.abs(y1-y2) );    	
        	
        	double _x1 = Math.min( Math.max( x1, px ), px+pw);
        	double _x2 = Math.min( Math.max( x2, px ), px+pw);
        	    	   	
        	rect.setFrame( Math.min(_x1, _x2), py, Math.abs(_x1-_x2), ph );    	
    	} else {
    		// Analog Zoom
        	double px = plot.getX();
        	double py = plot.getY();
        	double pw = plot.getWidth();
        	double ph = plot.analogAreaHeight;
    		
        	rect2.setFrame( Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1-x2), Math.abs(y1-y2) );    	
        	
        	double _x1 = Math.min( Math.max( x1, px ), px+pw);
        	double _x2 = Math.min( Math.max( x2, px ), px+pw);
        	double _y1 = Math.min( Math.max( y1, py ), py+ph);
        	double _y2 = Math.min( Math.max( y2, py ), py+ph);
        	    	   	
        	if (timeZoom) {
            	rect.setFrame( Math.min(_x1, _x2), py, Math.abs(_x1-_x2), plot.analogAreaHeight );    	        		
        	} else {
            	rect.setFrame( Math.min(_x1, _x2), Math.min(_y1, _y2), Math.abs(_x1-_x2), Math.abs(_y1-_y2) );    	        		
        	}
    	}    	
    	
    }

	@Override
	public void render(Graphics2D g2d) {		
		Composite c = g2d.getComposite();
		g2d.setComposite( composite );
		g2d.setColor( COLOR );
		g2d.fill( rect );
		g2d.setComposite( c );
		g2d.setStroke( STROKE );
		g2d.draw( rect );
	}
	
	@Override
	public Rectangle2D getBoundsInLocal() {		
		return rect;
	}

}
