/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.configuration;

import org.simantics.databoard.annotations.Union;

@Union({Scale.Manual.class, Scale.Auto.class})
public class Scale {

	public static class Manual extends Scale {
		public double min, max;
		public Manual() {}
		public Manual(double min, double max) {
			this.min = min;
			this.max = max;
		}
		@Override
		public String toString() {
			return "Manual";
		}
	}
	
	// Fit all samples
	public static class Auto extends Scale {
		@Override
		public String toString() {
			return "Auto";
		}
	}
	
}

