/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STSVariableViewerAdapter
extends AbstractResourceEditorAdapter
implements EditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(STSVariableViewerAdapter.class);

    public STSVariableViewerAdapter() {
        super("STS Variable Viewer", null, 20);
    }

    public boolean canHandle(ReadGraph g, Object input) throws DatabaseException {
        if (input instanceof IStructuredSelection) {
            input = ((IStructuredSelection)input).getFirstElement();
        }
        if (!(input instanceof Resource)) {
            if (input instanceof IAdaptable) {
                if ((input = ((IAdaptable)input).getAdapter(Resource.class)) == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        Resource resource = (Resource)input;
        return g.isInstanceOf(resource, TestsResource.getInstance((ReadGraph)g).STSVariable);
    }

    protected void openEditor(final Resource input) throws Exception {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return;
        }
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                final String variableName = (String)graph.getRelatedValue2(input, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
                final String contents = (String)graph.getRelatedValue2(input, TestsResource.getInstance((ReadGraph)graph).STSVariable_definition, (Binding)Bindings.STRING);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            WorkbenchUtils.openEditor((String)"org.simantics.tests.ui.stsVariableViewer", (IEditorInput)new STSVariableViewerEditorInput(variableName, contents));
                        }
                        catch (PartInitException e) {
                            LOGGER.error("Could not initialize part", (Throwable)e);
                        }
                    }
                });
            }
        });
    }

    public static class STSVariableViewerEditorInput
    implements IEditorInput {
        private String name;
        private String contents;

        public STSVariableViewerEditorInput(String name, String contents) {
            this.name = name;
            this.contents = contents;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return null;
        }

        public String getContents() {
            return this.contents;
        }
    }
}

