package org.simantics.tests.modelled.junit.v2;

import java.io.IOException;
import java.util.List;

import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.simantics.tests.modelled.utils.ModelledSTSTest;
import org.simantics.tests.modelled.utils.ModelledSTSTest.CommandSessionVariable;

public class ModelledSTSTestRunner extends Runner {

    private Description description;
    private ModelledSTSTest test;

    public ModelledSTSTestRunner(ModelledSTSTest test) {
        this.test = test;
    }

    @Override
    public Description getDescription() {
        if (description == null)
            description = Description.createTestDescription(test.getParentName(), test.getName(), new Integer(test.hashCode()));
        return description;
    }

    public List<CommandSessionVariable> runWithVars(List<CommandSessionVariable> vars) throws IOException {
        return test.run(vars);
    }
    
    @Override
    public void run(RunNotifier notifier) {
        throw new UnsupportedOperationException();
    }

    public boolean isIgnored() {
        return test.isIgnored();
    }

    public int getPriority() {
        return test.getPriority();
    }

    public ModelledSTSTest getTest() {
        return test;
    }
}
