/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui.handlers;

import java.io.File;
import java.nio.charset.Charset;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.ServerReference;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.team.Activator;
import org.simantics.team.internal.StagingLauncher;
import org.simantics.ui.workbench.handler.AbstractPreferenceHandler;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.ShowError;

public class StageEditHandler
extends AbstractPreferenceHandler {
    public StageEditHandler() {
        super((AbstractUIPlugin)Activator.getDefault());
    }

    private void showError(String msg, Throwable t) {
        String title = "Staging failed!";
        ShowError.showError((String)title, (String)msg, (Throwable)t);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        System.out.println("DEBUG: EditStageHandler");
        try {
            Session session = Simantics.getSession();
            File wsFolder = new File(Platform.getInstanceLocation().getURL().getFile());
            File stFolder = new File(wsFolder, "staging");
            if (!stFolder.isDirectory()) {
                throw new DatabaseException("Folder must exist. path=" + stFolder.getAbsolutePath());
            }
            this.show(session, stFolder);
        }
        catch (Throwable t) {
            this.showError("Staging failed:", t);
        }
        return null;
    }

    private void show(Session session, File stFolder) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            try {
                monitor.beginTask("begin", 1300);
                LifecycleSupport lfs = (LifecycleSupport)session.getService(LifecycleSupport.class);
                ServerReference sref = lfs.getSessionReference().getServerReference();
                String randomAccessId = "target";
                Resource targetLibrary = null;
                StagingLauncher.Config config = new StagingLauncher.Config(session, targetLibrary, stFolder, null);
                StagingLauncher.StagingResult result = StagingLauncher.launch(config, sref.toString(), randomAccessId);
                if (result.getExitValue() != 0) {
                    String msg = "";
                    if (result.getLogFile().exists()) {
                        byte[] data = FileUtils.readFile((File)result.getLogFile());
                        msg = new String(data, Charset.defaultCharset());
                    }
                    if (msg.isEmpty() || msg.matches(" *")) {
                        msg = "Staging crashed.";
                    }
                    ShowError.showError((String)("Staging failed, errorcode=" + result.getExitValue()), (String)msg, (Throwable)new Exception());
                }
                if (result.getMessageLog() != null) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Staging failed", (String)result.getMessageLog());
                }
            }
            catch (Exception e) {
                ErrorLogger.defaultLogError((Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

