/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.simantics.Simantics;
import org.simantics.db.Metadata;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.XSupport;
import org.simantics.team.Activator;
import org.simantics.ui.workbench.handler.AbstractPreferenceHandler;

public class DebugHandler
extends AbstractPreferenceHandler {
    public DebugHandler() {
        super((AbstractUIPlugin)Activator.getDefault());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Session s = Simantics.getSession();
            s.sync((WriteInterface)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    XSupport xs = (XSupport)graph.getService(XSupport.class);
                    Resource r = graph.newResource();
                    String msg = "Corrupt cluster r=" + r;
                    System.out.println(msg);
                    CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                    cm.add(msg);
                    xs.corruptCluster(r);
                    Resource rr = graph.newResource();
                    msg = "Corrupt cluster rr=" + rr;
                    System.out.println(msg);
                    cm.add(msg);
                    xs.corruptCluster(rr);
                    graph.addMetadata((Metadata)cm);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return null;
    }
}

