/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.simantics.db.Operation;
import org.simantics.db.Session;
import org.simantics.team.internal.Images;
import org.simantics.team.ui.ChangeSetElement;
import org.simantics.team.ui.UndoViewElement;

class UndoCombinedElement
extends UndoViewElement {
    private final Operation operation;
    private final Vector<ChangeSetElement> elements = new Vector();
    private String comment = null;

    UndoCombinedElement(Session session, Operation op) {
        super(session);
        this.operation = op;
    }

    @Override
    protected Image getIdImage() {
        return Images.getInstance().UNDO_IMAGE;
    }

    @Override
    protected String getIdText() {
        return "" + this.operation.getId();
    }

    @Override
    protected String getDateText() {
        if (this.elements.size() == 0) {
            this.getChildren();
        }
        if (this.elements.size() > 0) {
            return this.elements.firstElement().getDateText();
        }
        return null;
    }

    @Override
    protected String getCommentText() {
        if (this.elements.size() == 0) {
            this.getChildren();
        }
        if (this.elements.size() > 0) {
            return this.elements.firstElement().getCommentText();
        }
        return null;
    }

    @Override
    boolean hasChildren() {
        return this.operation.getOperations().size() > 0;
    }

    @Override
    Object[] getChildren() {
        Collection ops = this.operation.getOperations();
        int SIZE = ops.size();
        if (SIZE < 1) {
            return new Object[0];
        }
        this.elements.clear();
        Iterator it = ops.iterator();
        int i = 0;
        while (i < SIZE) {
            Operation op = (Operation)it.next();
            ChangeSetElement e = new ChangeSetElement(this.session, op.getCSId());
            this.elements.add(e);
            ++i;
        }
        if (this.elements.size() == 1) {
            return this.elements.firstElement().getChildren();
        }
        return this.elements.toArray();
    }

    public String toString() {
        this.getChildren();
        for (ChangeSetElement e : this.elements) {
            this.comment = e.toString();
            if (this.comment == null) continue;
            return this.comment;
        }
        return "no name";
    }
}

