package org.simantics.team.ui;

import java.io.File;
import java.util.Collections;
import java.util.List;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.simantics.db.common.NamedResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.team.ui.StageInitWizard.Data;
import org.simantics.utils.ui.ErrorLogger;

public class StageInitPage extends WizardPage {
    public static class Model implements Comparable<Model> {
        NamedResource model;
        public Model(NamedResource model) {
            this.model = model;
        }
        @Override
        public int compareTo(Model o) {
            return model.compareTo(o.model);
        }
        public NamedResource get() {
            return model;
        }
    }
    final Data data;
    Text stagingFolder;
    CCombo teamFolder;
    List<Model> models = Collections.emptyList();
    Button overwrite;
    protected StageInitPage(Data data) {
        super("Staging", "Initialize", null);
        this.data = data;
    }
    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, SWT.NONE);
        {
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 20;
            layout.verticalSpacing = 10;
            layout.numColumns = 3;
            container.setLayout(layout);
        }
        new Label(container, SWT.NONE).setText("Workbench folder:");
        stagingFolder = new Text(container, SWT.BORDER);
        {
            stagingFolder.setEditable(false);
            stagingFolder.setText(data.stagingFolder.getAbsolutePath());
            stagingFolder.setToolTipText("Shows the folder of the staging workbench.");
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo(stagingFolder);
        }
        new Label(container, SWT.NONE).setText("&Team folder:");
        teamFolder = new CCombo(container, SWT.BORDER);
        {
            if (null != data.teamFolder)
                teamFolder.setText(data.teamFolder.getAbsolutePath());
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo(teamFolder);
            teamFolder.addModifyListener(new ModifyListener(){
                @Override
                public void modifyText(ModifyEvent e) {
                    validatePage();
                }
            });
        }
        Button browseFileButton = new Button(container, SWT.PUSH);
        {
            browseFileButton.setText("B&rowse...");
            browseFileButton.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false));
            browseFileButton.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dd = new DirectoryDialog(getShell(), SWT.OPEN);
                    dd.setText("Choose team folder");
                    File folder = new File(teamFolder.getText());
                    if (folder.isDirectory())
                        dd.setFilterPath(folder.getAbsolutePath());
                    else {
                        folder = folder.getParentFile();
                        if (null != folder && folder.isDirectory())
                            dd.setFilterPath(folder.getParent());
                        else if (null != data.teamFolder && data.teamFolder.isDirectory())
                            dd.setFilterPath(data.teamFolder.getAbsolutePath());
                        else {
                            String temp = System.getProperty("java.io.tmpdir");
                            if (null != temp && !temp.equals(""))
                                dd.setFilterPath(temp);
                        }
                    }
                    String dir = dd.open();
                    if (dir == null)
                        return;
                    teamFolder.setText(dir);
                    validatePage();
                }
            });
        }
        try {
            initializeData();
        } catch (DatabaseException e) {
            ErrorLogger.defaultLogError(e);
        }
        setControl(container);
        validatePage();
    }

    private void initializeData() throws DatabaseException {
        for (String path : data.recentLocations) {
            teamFolder.add(path);
        }
        if (teamFolder.getItemCount() > 0)
            teamFolder.select(0);
    }

    void validatePage() {
        String importLoc = teamFolder.getText();
        if (importLoc.isEmpty()) {
            setMessage("Select folder for team data.");
            setErrorMessage(null);
            setPageComplete(false);
            return;
        }
        File folder = new File(importLoc);
        if (!folder.exists() || !folder.isDirectory()) {
            setErrorMessage("Selected folder is invalid.");
            setPageComplete(false);
            return;
        }
        int count = folder.list().length;
        if (!data.requireExisting) {
            if (count > 0) {
                setErrorMessage("Selected folder is not empty.");
                setPageComplete(false);
                return;
            }
        } else
            if (count == 0) {
                setErrorMessage("Selected folder is not team folder.");
                setPageComplete(false);
                return;
            }
        data.teamFolder = folder;
        data.comment = "Initial commit."; // TODO: get comment from user.
        setErrorMessage(null);
        setMessage("Stage " + folder.getAbsolutePath() + ".");
        setPageComplete(true);
    }
}
