package org.simantics.structural2.variables;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public interface Connection {

    /**
     * Return absolute URIs of the connection points. An optional (may be null) relationType may be used
     * to filter the returned connection points.
     */
	Collection<String> getConnectionPointURIs(ReadGraph graph, Resource relationType) throws DatabaseException;
    /**
     * Return the connection points. An optional (may be null) relationType may be used
     * to filter the returned connection points.
     */
	Collection<Variable> getConnectionPoints(ReadGraph graph, Resource relationType) throws DatabaseException;
	
	Collection<VariableConnectionPointDescriptor> getConnectionPointDescriptors(ReadGraph graph, Resource relationType) throws DatabaseException;

	Connection2 getConnection2();

}
