package org.simantics.structural2;

import java.util.ArrayList;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.primitiverequest.PossibleObject;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableInterface;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;

/**
 * @deprecated Don't use this class anymore. It contains nothing worth using.
 */
@Deprecated
final public class StructuralVariables {

	private static final boolean DEBUG = false;

	
	public static Resource getCompositeParent(Session session, Resource component) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(session);
		StructuralResource2 sr = StructuralResource2.getInstance(session);
		Resource parent = session.syncRequest( new PossibleObject(component, L0.PartOf) );
		if(parent == null) return null;
		if ( session.syncRequest( Queries.isInstanceOf(parent, sr.Component) )) return parent;
		return null;
		
	}
	
	public static Resource getCompositeParent(ReadGraph graph, Resource component) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		StructuralResource2 sr = StructuralResource2.getInstance(graph);
		Resource parent = graph.getPossibleObject(component, L0.PartOf);
		if(parent == null) return null;
		if(graph.isInstanceOf(parent, sr.Composite)) return parent;
		return null;
		
	}

	public static ResourceArray getCompositeArray(Session session, Resource composite) throws DatabaseException {
		
		ArrayList<Resource> path = new ArrayList<Resource>();
		while(composite != null) {
			path.add(composite);
			composite = getCompositeParent(session, composite);
		}
		return new ResourceArray(path).reversed();
		
	}
	
	public static ResourceArray getCompositeArray(ReadGraph graph, Resource composite) throws DatabaseException {
		
		ArrayList<Resource> path = new ArrayList<Resource>();
		while(composite != null) {
			path.add(composite);
			composite = getCompositeParent(graph, composite);
		}
		return new ResourceArray(path).reversed();
		
	}
	
	public static ResourceArray getComponentArray(ReadGraph graph, Resource component) throws DatabaseException {
		
		Resource composite = getCompositeParent(graph, component);
		return getCompositeArray(graph, composite).appended(component);
		
//		ArrayList<Resource> path = new ArrayList<Resource>();
//		path.add(component);
//		component = getCompositeParent(graph, component);
//		while(component != null) {
//			path.add(component);
//			component = getCompositeParent(graph, component);
//		}
//		return new ResourceArray(path).reversed();
		
	}

	public static ResourceArray getComponentArray(ReadGraph graph, ResourceArray prefix, Resource component) throws DatabaseException {
		
		return prefix.appended(getComponentArray(graph, component));
		
	}

	static Resource getModel(ReadGraph graph, ResourceArray path) throws DatabaseException {
		
		// The first element is the configuration composite
		return graph.getPossibleObject(path.resources[0], SimulationResource.getInstance(graph).IsConfigurationOf);
		
	}
	
	public static Resource getRootComposite(ReadGraph graph, Resource component) throws DatabaseException {

		ResourceArray fullPath = getComponentArray(graph, ResourceArray.EMPTY, component);
		return fullPath.head();
		
	}
	
	public static Variable getVariable(ReadGraph graph, ResourceArray path, Resource component) throws DatabaseException {
		
		ResourceArray fullPath = getComponentArray(graph, path, component);
		Resource model = getModel(graph, fullPath);
		if(model == null) return null;
		VariableInterface variables = graph.adapt(model, VariableInterface.class);
		return variables.getVariable(graph, fullPath.removeFromBeginning(1));
		
	}

    /**
     * @param graph
     * @param array
     * @return RVI, never <code>null</code>
     * @throws DatabaseException
     */
    public static String getRVI(ReadGraph graph, ResourceArray array) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        String result = "";
        for(Resource r : array) {
            if(DEBUG) System.out.println("Variables.getRVI " + NameUtils.getSafeName(graph, r) );
            String name = graph.getRelatedValue(r, L0.HasName, Bindings.STRING);
            String segment = URIStringUtils.escape(name);
            result += "/" + segment;
        }
        return result;
    }
    
    public static String getRVI(Session session, ResourceArray array) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(session);
        String result = "";
        for(Resource r : array) {
        	String safeName = session.syncRequest( Queries.safeName(r) );
            if(DEBUG) System.out.println("Variables.getRVI " + safeName );            
            String name = (String) session.syncRequest( Queries.getRelatedValue(r, L0.HasName, Bindings.STRING) );
            String segment = URIStringUtils.escape(name);
            result += "/" + segment;
        }
        return result;
    }
    

    /**
     * @param graph
     * @param array
     * @return RVI or <code>null</code> if it can't be resolved
     * @throws DatabaseException
     */
    public static String getPossibleRVI(ReadGraph graph, ResourceArray array) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        String result = "";
        for(Resource r : array) {
            if(DEBUG) System.out.println("Variables.getRVI " + NameUtils.getSafeName(graph, r) );
            String name = graph.getPossibleRelatedValue(r, L0.HasName, Bindings.STRING);
            if (name == null)
                return null;
            String segment = URIStringUtils.escape(name);
            result += "/" + segment;
        }
        return result;
    }

	public static Resource getModel(ReadGraph graph, Resource composite) throws DatabaseException {
		return graph.syncRequest(new PossibleTypedParent(composite, SimulationResource.getInstance(graph).Model));
	}

	public static Resource getBaseRealization(ReadGraph graph, Resource composite) throws DatabaseException {
		Layer0X L0X = Layer0X.getInstance(graph);
		Resource model = getModel(graph, composite);
		if(model == null) return null;
		return graph.getPossibleObject(model, L0X.HasBaseRealization);
	}
	
}
