/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.ui.modelBrowser.contributions;

import java.util.Collection;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.EvaluatorImpl;
import org.simantics.browsing.ui.common.extension.EvaluatorFactory;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.content.LabelDecoratorFactory;
import org.simantics.utils.ReflectionUtils;

public abstract class PartialEvaluatorFactory<T>
implements EvaluatorFactory {
    private final Class<?> clazz = ReflectionUtils.getSingleParameterType(this.getClass());

    public EvaluatorData.Evaluator create(Collection<String> browseContexts) {
        EvaluatorImpl result = new EvaluatorImpl();
        double preference = this.getPreference();
        ComparableContextFactory factory = this.createComparableFactory();
        if (factory != null) {
            result.addComparator(factory, preference);
        }
        if ((factory = this.createLabelDecoratorFactory()) != null) {
            result.addLabelDecorator((LabelDecoratorFactory)factory, preference);
        }
        if ((factory = this.createImagerFactory()) != null) {
            result.addImager((ImagerFactory)factory, preference);
        }
        return result;
    }

    protected double getPreference() {
        return 1.0;
    }

    protected ComparableContextFactory createComparableFactory() {
        return null;
    }

    protected LabelDecoratorFactory createLabelDecoratorFactory() {
        return null;
    }

    protected ImagerFactory createImagerFactory() {
        return null;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }
}

