/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.ui.menuContributions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.processors.ShowMaxChildrenProcessor;
import org.simantics.browsing.ui.content.PrunedChildrenResult;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.structural.ui.Activator;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ShowAllChildrenContribution
extends CompoundContributionItem {
    static IContributionItem[] NONE = new IContributionItem[0];

    protected IContributionItem[] getContributionItems() {
        IWorkbenchPart part = WorkbenchUtils.getActiveWorkbenchPart();
        if (part == null) {
            return NONE;
        }
        GraphExplorer explorer = (GraphExplorer)part.getAdapter(GraphExplorer.class);
        if (explorer == null) {
            return NONE;
        }
        ISelectionProvider sp = (ISelectionProvider)explorer.getAdapter(ISelectionProvider.class);
        if (sp == null) {
            return NONE;
        }
        ISelection s = sp.getSelection();
        List nodes = ISelectionUtils.getPossibleKeys((Object)s, (IHintContext.Key)SelectionHints.KEY_MAIN, NodeContext.class);
        if (nodes.isEmpty()) {
            return NONE;
        }
        boolean allTruncated = true;
        for (NodeContext node : nodes) {
            PrunedChildrenResult prunedChildren = (PrunedChildrenResult)explorer.query(node, (NodeContext.CacheKey)BuiltinKeys.PRUNED_CHILDREN);
            NodeContext[] finalChildren = (NodeContext[])explorer.query(node, (NodeContext.CacheKey)BuiltinKeys.FINAL_CHILDREN);
            if (prunedChildren != null && finalChildren != null && prunedChildren.getPrunedChildren().length != finalChildren.length) continue;
            allTruncated = false;
            break;
        }
        if (!allTruncated) {
            return NONE;
        }
        ShowMaxChildrenProcessor processor = (ShowMaxChildrenProcessor)explorer.getPrimitiveProcessor(BuiltinKeys.SHOW_MAX_CHILDREN);
        if (processor == null) {
            return NONE;
        }
        return new IContributionItem[]{new ActionContributionItem((IAction)new ShowAllChildrenAction(processor, nodes))};
    }

    static class ShowAllChildrenAction
    extends Action {
        private ShowMaxChildrenProcessor processor;
        private List<NodeContext> nodes;

        public ShowAllChildrenAction(ShowMaxChildrenProcessor processor, List<NodeContext> nodes) {
            super("Show All Children");
            this.setImageDescriptor(Activator.SHOW_ALL_CHILDREN_ICON);
            this.processor = processor;
            this.nodes = nodes;
        }

        public void run() {
            for (NodeContext node : this.nodes) {
                this.processor.replaceShowMaxChildren(node, Integer.MAX_VALUE);
            }
        }
    }
}

