/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.ui.compositeViewer;

import java.util.HashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.graphviz.Edge;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.Identifiable;
import org.simantics.graphviz.Node;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

public class CreateCompositeGraph
implements Read<Graph> {
    Resource composite;
    Graph graph;
    HashMap<Resource, Node> connections = new HashMap();

    public CreateCompositeGraph(Resource composite) {
        this.composite = composite;
    }

    private static String getName(ReadGraph g, Resource r) throws DatabaseException {
        String s = (String)g.getPossibleRelatedValue(r, Layer0.getInstance((ReadGraph)g).HasName);
        if (s == null) {
            s = NameUtils.getSafeName((ReadGraph)g, (Resource)r);
        }
        return s;
    }

    private void connect(Node parent, String label, Resource connection) {
        Node cn = this.connections.get(connection);
        if (cn == null) {
            cn = new Node((IGraph)this.graph);
            cn.setShape("diamond");
            cn.setFixedSize(true);
            cn.setWidth(0.2);
            cn.setHeight(0.2);
            this.connections.put(connection, cn);
        }
        Edge edge = new Edge((Identifiable)parent, (Identifiable)cn);
        edge.setArrowhead("none");
        if (label.contains("Self")) {
            edge.setColor("red");
        } else {
            edge.setTailLabel(label);
        }
        edge.set("fontsize", "8");
    }

    public Graph perform(ReadGraph g) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        this.graph = new Graph();
        this.graph.set("overlap", "false");
        this.graph.set("splines", "true");
        for (Resource child : g.getObjects(this.composite, L0.ConsistsOf)) {
            Node node = new Node((IGraph)this.graph, CreateCompositeGraph.getName(g, child));
            node.setShape("rect");
            if (g.isInstanceOf(child, STR.Composite)) {
                for (Resource c : g.getObjects(child, STR.HasConnectionJoin)) {
                    this.connect(node, "", c);
                }
                continue;
            }
            for (Statement stat : g.getStatements(child, STR.IsConnectedTo)) {
                String label = CreateCompositeGraph.getName(g, stat.getPredicate());
                this.connect(node, label, stat.getObject());
            }
        }
        Graph rgraph = this.graph;
        this.graph = null;
        this.connections.clear();
        return rgraph;
    }

    static class Connection {
        Node parent;
        String label;

        public Connection(Node parent, String label) {
            this.parent = parent;
            this.label = label;
        }
    }
}

