/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.adapters;

import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Template;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;

public class DiagramTemplate implements Template {

    Resource template;

    public DiagramTemplate(Resource template) {
        this.template = template;
    }

    @Override
    public void apply(WriteGraph g, Map<String, Object> parameters)
    throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(g);
        Layer0X L0X = Layer0X.getInstance(g);
        DiagramResource DIA = DiagramResource.getInstance(g);
        ModelingResources mr = ModelingResources.getInstance(g);

        Resource composite = (Resource)parameters.get("");
        CommonDBUtils.selectClusterSet(g, composite);

        Resource diagramType = g.getSingleObject(template, mr.HasDiagramType);

        Resource diagram = (Resource)parameters.get("diagram");
        if (diagram == null) {
            diagram = g.newResource();
            parameters.put("diagram", diagram);
        }

        
        
//        // Description
//        Resource descriptionType = g.getPossibleObject(template, mr.HasDefaultDocumentType);
//        if(descriptionType != null) {
//        	DocumentResource DOC = DocumentResource.getInstance(g);
//            Resource description = g.newResource();
//            g.claim(description, l0.InstanceOf, null, descriptionType);
//            g.claimLiteral(description, l0.HasName, "Description");
//            g.claim(description, l0.PartOf, composite);
//            g.claim(composite, DOC.HasDocument, description);
//        }
        
        g.claim(diagram, l0.InstanceOf, null, diagramType);
        g.claim(diagram, l0.SubrelationOf, null, l0.HasNext);
        g.claim(diagram, mr.DiagramToComposite, composite);
        Resource diagramInv = g.newResource();
        g.claim(diagramInv, l0.InverseOf, diagram);
        g.claim(diagramInv, l0.SubrelationOf, null, l0.HasPrevious);
        g.claim(diagram, diagram, diagramInv, diagram);
        Resource mapping = g.newResource();
        g.claim(diagram, L0X.HasTrigger, mapping);
        
        Resource mappingType = g.getPossibleObject(template, mr.DiagramTemplate_HasMappingType);
        if(mappingType != null) {
        	g.claim(mapping, l0.InstanceOf, mappingType);
        }

        String name = (String) parameters.get("name");
        if (name == null)
            name = "__DIAGRAM__";
        g.claimLiteral(diagram, l0.HasName, name, Bindings.STRING);

        // Make diagram part of a dummy container entity attached to the parent
        // composite if it's not already part of something.
        if (!g.hasStatement(diagram, l0.PartOf)) {
            Resource container = g.newResource();
            g.claim(container, l0.InstanceOf, null, DIA.DiagramContainer);
            g.addLiteral(container, l0.HasName, l0.NameOf, l0.String, "__CONTAINER__", Bindings.STRING);
            g.claim(container, l0.ConsistsOf, diagram);
            g.claim(composite, l0.ConsistsOf, container);
        }
    }

}
