package org.simantics.structural.synchronization.utils;

import java.util.Collection;

import org.simantics.structural.synchronization.protocol.ChildInfo;
import org.simantics.structural.synchronization.protocol.Connection;
import org.simantics.structural.synchronization.protocol.SerializedVariable;
import org.simantics.structural.synchronization.protocol.SynchronizationEventHandler;
import org.simantics.structural.synchronization.protocol.SynchronizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticSynchronizationEventHandler implements SynchronizationEventHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticSynchronizationEventHandler.class);
    int indentation;

    @Override
    public void beginSynchronization() {
    }

    @Override
    public void endSynchronization() {
    }

    @Override
    public void beginComponent(String name, String typeId,
            Collection<SerializedVariable> properties,
            Collection<Connection> connections, Collection<ChildInfo> children)
                    throws SynchronizationException {
        StringBuilder indent = new StringBuilder();
        for(int i=0;i<indentation;++i)
            indent.append("  ");
        indent.append(name);
        if(typeId != null)
            indent.append(" :: " + typeId);
        LOGGER.info(indent.toString());
        for(SerializedVariable var : properties) {
            indent = new StringBuilder();
            for(int i=0;i<=indentation;++i)
                indent.append("  ");
            indent.append(SerializedVariable.print(var, indentation*2+2));
            LOGGER.info(indent.toString());
        }
        for(Connection connection : connections) {
            indent = new StringBuilder();
            for(int i=0;i<=indentation;++i)
                indent.append("  ");
            indent.append(connection);
            LOGGER.info(indent.toString());
        }
        if(!children.isEmpty()) {
            indent = new StringBuilder();
            for(int i=0;i<=indentation;++i)
                indent.append("  ");
            indent.append("Children ");
            if(children != null)
                indent.append(children);
            LOGGER.info(indent.toString());
        }
        ++indentation;
    }

    @Override
    public void endComponent() {
        --indentation;
    }

    @Override
    public void beginType(String id, Collection<SerializedVariable> properties) {
        LOGGER.info("--- Type " + id + " --------------------------------");
        for(SerializedVariable var : properties)
            LOGGER.info(SerializedVariable.print(var, 2));
    }

    @Override
    public void endType() {
        LOGGER.info("----------------------------------------------------");
    }

    @Override
    public void reportProblem(String description) {
        LOGGER.error(description);
    }

    @Override
    public void reportProblem(String description, Exception e) {
        LOGGER.error(description, e);
    }

}
