package org.simantics.spreadsheet.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.ui.TableSelection;
import org.simantics.spreadsheet.ui.editor.NoCellTab.NoCellInput;

/**
 * @author Tuukka Lehtonen
 */
public class SpreadsheetSelectionProcessor implements SelectionProcessor<Collection<?>, ReadGraph> {

    @Override
    public Collection<?> process(Collection<?> selection, ReadGraph graph) {
    	try {
	        if(selection == null) return Collections.emptyList();
	        if(selection.size() != 3) return Collections.emptyList();
	        Iterator<?> it = selection.iterator();
	        final Variable variable = (Variable)it.next();
	        it.next();
	        final TableSelection sel = (TableSelection)it.next();
	        int row = sel.getRows()[0];
	        int column = sel.getColumns()[0];
	        String location = Spreadsheets.cellName(row, column);
	        ArrayList<ComparableTabContributor> result = new ArrayList<ComparableTabContributor>(); 
	        final Variable cell = variable.getPossibleChild(graph, location);
	        if(cell != null) {
	        	SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
	        	//result.add(new ComparableTabContributor(new SheetTab(), 2, variable, "Sheet"));
	        	final Resource type = cell.getPossiblePropertyValue(graph, Variables.TYPE);
	        	if(sr.TextCell.equals(type)) {
	        		result.add(new ComparableTabContributor(new TextCellTab(), 3, cell, "Configuration"));
//	        	if(sr.ExpressionRealization.equals(type)) {
//	        		Variable expression = cell.getPossibleProperty(graph, "Expression");
//	        		if(expression != null) {
//		        		result.add(new ComparableTabContributor(new ExpressionCellTab(), 3, cell, "Configuration"));
//	        		} else {
//	        			
//	        		}
//	        	} else if(sr.CommandRealization.equals(type)) {
//	        		result.add(new ComparableTabContributor(new CommandCellTab(), 3, cell, "Configuration"));
//	        	} else if(sr.TextRealization.equals(type)) {
//	        		result.add(new ComparableTabContributor(new TextCellTab(), 3, cell, "Configuration"));
//	        	} else if(sr.MatrixRealization.equals(type)) {
//	        		result.add(new ComparableTabContributor(new MatrixCellTab(), 3, cell, "Configuration"));
//		        	}
//	        	System.out.println("cell type = " + type);
//		        final String content = cell.getPossiblePropertyValue(graph, "Content");
//		        if(content != null) {
//		        	final Variable contentVariable = Variables.getVariable(graph, content);
//		        	if(variable == null) return Collections.emptyList();
//		        	return Collections.singleton(new ComparableTabContributor(new SpreadsheetTab(), 3, contentVariable, "Configuration"));
		        } else {
		        	return Collections.emptyList();
		        }
	        } else {
	        	result.add(new ComparableTabContributor(new NoCellTab(), 3, new NoCellInput(variable, location), "Configuration"));
	        }
	        return result;
    	} catch (Throwable t) {
    		t.printStackTrace();
    		return Collections.emptyList();
    	}
    }

}