package org.simantics.spreadsheet.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellRenderer;

import org.simantics.spreadsheet.ClientModel;

public class SpreadsheetTableUI extends BasicTableUI {

	@Override
	public void paint(Graphics g, JComponent c) {
		SpreadsheetTable t = ((SpreadsheetTable)table);		
		ClientModel clientModel = t.getClientModel();
		if (clientModel == null) return;
		
		Rectangle clip = g.getClipBounds();
		
		Point corner0 = new Point(clip.x, clip.y);
		Point corner1 = new Point(new Point(clip.x + clip.width - 1, clip.y + clip.height - 1));
		
		int row0 = t.rowAtPointWithoutSpan(corner0);
		if (row0 == -1) row0 = 0;
		
		int row1 = t.rowAtPointWithoutSpan(corner1);
		if (row1 == -1) row1 = t.getRowCount() - 1;
		
		int col0 = t.columnAtPointWithoutSpan(corner0);
		if (col0 == -1) col0 = 0;
		
		int col1 = t.columnAtPointWithoutSpan(corner1);
		if (col1 == -1) col1 = t.getColumnCount() - 1;
		
		for (int row = row0; row <= row1; row++) {
			for (int col = col0; col <= col1; col++) {
				Rectangle span = clientModel.getSpan(row, col);
				if (span == null) {
					paintCell(row, col, g, t.getCellRect(row, col, true));
				} else if ((col == span.x) && (row == span.y)) {
					paintCell(span.y, span.x, g, t.getCellRect(span.y, span.x, true));
				} else if ((row == row0) || (col == col0)) {
					// this condition is not optimal as it draws multi-span boundary cells many times
					paintCell(span.y, span.x, g, t.getCellRect(span.y, span.x, true));
				}
			}
		}
	}
		
	private void paintCell(int row, int column, Graphics g, Rectangle rect) {
		if (table.isEditing() && (table.getEditingRow() == row) && (table.getEditingColumn() == column)) {
		      Component component = table.getEditorComponent();
		      component.setBounds(rect);
		      component.validate();
	    } else {
			TableCellRenderer renderer = table.getCellRenderer(row, column);
	    	Component component = table.prepareRenderer(renderer, row, column);
			if (component.getParent() == null) {
				rendererPane.add(component);
			}
			rendererPane.paintComponent(g, component, table, rect.x, rect.y, rect.width, rect.height, false);
	    }
	}
	
	public static ComponentUI createUI(JComponent c) {
		return new SpreadsheetTableUI();
	}
}
