package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.SpreadsheetMatrix;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;

class SumifFormulaFunction implements CellFormulaFunction<Object> {

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() == 2) {
            Object test = args.values.get(0).accept(visitor);
            Object criteria = null;
            try {
                criteria = args.values.get(1).accept(visitor);
            } catch (IllegalStateException e){
                return 0;
            }
            FormulaError2 error = FormulaError2.forObject(criteria);
            if(error!=null) return error.getString();

            if (test instanceof SpreadsheetMatrix) {
                double sum = 0.0;
                SpreadsheetMatrix tm = (SpreadsheetMatrix) test;
                for (int i = 0; i < tm.values.length; i++) {
                    if (Spreadsheets.matchCriteria(tm.values[i], criteria)) {
                        double d = Spreadsheets.asNumber(tm.values[i]);
                        if (Double.isFinite(d))
                            sum += d;
                    }
                }
                return sum;
            } else {
                Double d = Spreadsheets.asNumber(test);
                return d;
            }
        }

        if (args.values.size() == 3) {
            Object test = args.values.get(0).accept(visitor);
            Object criteria = null;
            try {
                criteria = args.values.get(1).accept(visitor);
            } catch (IllegalStateException e){
                return 0;
            }
            FormulaError2 error = FormulaError2.forObject(criteria);
            if(error!=null) return error.getString();

            Object range = args.values.get(2).accept(visitor);

            if (test instanceof SpreadsheetMatrix) {
                Double sum = 0.0;
                SpreadsheetMatrix tm = (SpreadsheetMatrix) test;
                SpreadsheetMatrix rm = (SpreadsheetMatrix) range;
                for (int i = 0; i < tm.values.length; i++) {
                    if (Spreadsheets.matchCriteria(tm.values[i], criteria)) {
                        double d = Spreadsheets.asNumber(rm.values[i]);
                        if (Double.isFinite(d))
                            sum += d;
                    }
                }
                return sum;
            } else {
                Double d = Spreadsheets.asNumber(test);
                return d;
            }

        }
        throw new IllegalStateException();
    }
}