package org.simantics.spreadsheet.solver.formula;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.SpreadsheetMatrix;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValue;

public class AverageFormulaFunction implements CellFormulaFunction<Object> {

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() == 0)
            throw new IllegalStateException();
        Double sum = 0.0;
        double count = 0.0;
        for(AstValue value : args.values){
            Object res = value.accept(visitor);
            if (res instanceof SpreadsheetMatrix) {
                Object value2 = ((SpreadsheetMatrix) res).sumWithFormulaError();
                if(value2 instanceof String) return value2;

                sum += ((Number)value2).doubleValue();
                count += ((SpreadsheetMatrix) res).countOfActualDoubleValues();
            } else {
                FormulaError2 err = FormulaError2.forObject(res);
                if(err!=null) return err.getString();

                if(res instanceof Variant){
                    Double dVal = Spreadsheets.asDoubleWhereEmptyStringIsZero(res);
                    if(dVal==null) res = ((Variant)res).toString();
                    else res = dVal;
                }

                Double v = null;
                if(res instanceof String && !res.equals("")){
                    v = Spreadsheets.asDoubleWhereEmptyStringIsZero(res);
                }
                else if(res instanceof Number)
                    v = Spreadsheets.asDoubleWhereEmptyStringIsZero(res);

                if(v!=null){
                    sum += v;
                    count++;
                }
            }
        }
        if(count==0.0) return FormulaError2.DIV0.getString();
        return sum/count;
    }
}