package org.simantics.spreadsheet.graph.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableSpaceManipulator;
import org.simantics.layer0.Layer0;

public class SheetVariableSpaceManipulator implements VariableSpaceManipulator {
    
    private Variable variable;
    public SheetVariableSpaceManipulator(Variable variable) {
        this.variable = variable;
    }

    @Override
    public void apply(WriteGraph graph, Modification modification) throws DatabaseException {
        
        Layer0 L0 = Layer0.getInstance(graph);
        for(String name : modification.removedChildren) {
            Variable child = variable.getChild(graph, name);
            Resource represents = child.getRepresents(graph);
            graph.deny(represents, L0.PartOf);
        }
        
        for(ChildCreationData data : modification.newChildren) {
            Resource container = variable.getRepresents(graph);
            Resource cell = graph.newResource();
            Resource type = graph.getResource(data.type);
            graph.claim(cell, L0.InstanceOf, null, type);
            graph.addLiteral(cell, L0.HasName, L0.NameOf, L0.String, data.name, Bindings.STRING);
            for(PropertyCreationData p : data.properties) {
                Resource property = graph.getResource(p.name);
                graph.claimLiteral(cell, property, p.value.getValue());
            }
            graph.claim(cell, L0.PartOf, container);
            
        }
    }

}
