package org.simantics.simulator.toolkit.db;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.NodeManagerVariableBuilder;
import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.simulator.toolkit.StandardNodeManager;

public abstract class StandardVariableManagerVariableBuilder extends NodeManagerVariableBuilder {

    @Override
    protected Object getRoot(ReadGraph graph, NodeSupport<?> support, String sessionName) {
        StandardNodeManager manager = (StandardNodeManager)support.manager;
        return manager.getRoot();
    }
    
    /*
     * For compatibility reasons. Existing implementations implement getNodeSupport directly and in that case this is not needed.
     * New implementations should not implement getNodeSupport but rather implement this.
     */
    protected StandardVariableSessionManager getSessionManager() {
        throw new UnsupportedOperationException();
    }
    
    protected NodeSupport<?> getNodeSupport(ReadGraph graph, String sessionName) throws DatabaseException {
        return getSessionManager().getOrCreateNodeSupport(graph, sessionName);
    }

}
