/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers.e4;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.simantics.Simantics;
import org.simantics.simulation.experiment.ExperimentUtil;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;

public class Run {
    public static final String RUN_STATE_EVENT = "runSimulationEvent";
    public static final String SIMULATION_RUN_STATE = "org.simantics.simulation.ui.run.state";
    private static final String HANDLED_ITEM_ID = "org.simantics.simulation.ui.handledtoolitem.Run";
    @Inject
    EModelService modelService;

    @CanExecute
    public boolean canExecute() {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (manager == null) {
            return false;
        }
        IExperiment experiment = manager.getActiveExperiment();
        return experiment != null;
    }

    @Execute
    public void execute(MHandledItem handledItem) {
        ExperimentUtil.simulate((boolean)handledItem.isSelected());
    }

    @Inject
    @Optional
    public void handleEvent(@UIEventTopic(value="org/simantics/simulation/state/*") boolean state, MApplication application) {
        List items = this.modelService.findElements((MUIElement)application, HANDLED_ITEM_ID, MHandledItem.class, null);
        if (!items.isEmpty()) {
            for (MHandledItem handledItem : items) {
                handledItem.setSelected(state);
                if (handledItem.isSelected()) {
                    handledItem.setIconURI("platform:/plugin/org.simantics.simulation.ui/icons/control_pause.png");
                    handledItem.setTooltip("Pause");
                    continue;
                }
                handledItem.setIconURI("platform:/plugin/org.simantics.simulation.ui/icons/control_play.png");
                handledItem.setTooltip("Run");
            }
        }
    }
}

