/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.experiment;

import java.util.concurrent.locks.Lock;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;

public interface IExperiment {

	<T> T getService(Class<T> clazz);
	
    String getIdentifier();

    ExperimentState getState();
    ExperimentState getState(ReadGraph graph) throws DatabaseException;
    void changeState(ExperimentState state);

    Resource getResource();
    Resource getModel();

    /**
     * @param monitor
     *            the progress monitor to use for reporting progress to the user
     *            during the operation. It is the caller's responsibility to
     *            call done() on the given monitor. Accepts null, indicating
     *            that no progress should be reported and that the operation
     *            cannot be cancelled.
     */
    void shutdown(IProgressMonitor monitor);

    void addListener(IExperimentListener listener);
    void removeListener(IExperimentListener listener);

    void addStatusListener(IExperimentStatusListener listener);
    void removeStatusListener(IExperimentStatusListener listener);

    //Historian getDataSession();
    
    /**
     * Get the lock object to the datasource. Lock must be acquired
     * for write operations.  
     */
    Lock getDatasourceLock();
    
    /**
     * Get an accessor to the experiment.
     * The returned accessor follows Datasource Contract.
     * https://www.simantics.org/wiki/index.php/Databoard_Specification#Datasource_Contract
     * 
     * @return valuation accessor
     */
    Accessor getAccessor();

    /**
     * Synchronizes the running experiment with configuration.
     */
    public void refresh(Session session);
    public void refresh(RequestProcessor session);
    
}
