/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.ModelledTabContributor;
import org.simantics.selectionview.SelectionViewResources;
import org.simantics.selectionview.TabContribution;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.views.swt.SWTViewLoaderProcess;
import org.simantics.views.swt.client.base.SWTRoot;

public class TypedVariableTabContribution
implements TabContribution<Object> {
    private final Resource configuration;

    public TypedVariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
        this.configuration = configuration;
    }

    @Override
    public boolean accept(ReadGraph graph, Object input) {
        return true;
    }

    private Variable getPossibleVariable(ReadGraph graph, Object input) throws DatabaseException {
        if (input instanceof Variable) {
            return (Variable)input;
        }
        return WorkbenchSelectionUtils.getPossibleVariable((RequestProcessor)graph, (Object)input);
    }

    @Override
    public void contribute(ReadGraph graph, Object object, Collection<ComparableTabContributor> result) throws DatabaseException {
        Variable variable = this.getPossibleVariable(graph, object);
        if (variable == null) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        Collection types = graph.getObjects(this.configuration, SEL.TypedVariableTabContribution_HasType);
        if (types.isEmpty()) {
            throw new DatabaseException("No type for " + graph.getPossibleURI(this.configuration));
        }
        Resource view = graph.getPossibleObject(this.configuration, SEL.VariableTabContribution_HasView);
        if (view == null) {
            throw new DatabaseException("No view for " + graph.getPossibleURI(this.configuration));
        }
        Integer priority = (Integer)graph.getPossibleRelatedValue(this.configuration, SEL.VariableTabContribution_HasPriority, (Binding)Bindings.INTEGER);
        String label = (String)graph.getPossibleRelatedValue(this.configuration, L0.HasLabel);
        String viewURI = graph.getPossibleURI(view);
        Resource resource = variable.getPossibleRepresents(graph);
        if (resource == null) {
            return;
        }
        Set ts = graph.getTypes(resource);
        if (!Collections.disjoint(types, ts)) {
            for (Resource r : graph.getObjects(this.configuration, SEL.VariableTabContribution_HasTest)) {
                Boolean pass = (Boolean)Functions.exec((RequestProcessor)graph, (Resource)r, (Object[])new Object[]{graph, variable});
                if (pass.booleanValue()) continue;
                return;
            }
            try {
                Variable transformed = (Variable)Simantics.tryInvokeSCL((ReadGraph)graph, (Resource)this.configuration, (Resource)SEL.VariableTabContribution_transformation, (Object)variable);
                if (transformed != null) {
                    variable = transformed;
                }
            }
            catch (DatabaseException databaseException) {}
            result.add(new ComparableTabContributor(new Contribution(viewURI), priority.intValue(), variable, label));
        }
    }

    static class Contribution
    extends ModelledTabContributor {
        private String viewURI;

        public Contribution(String viewURI) {
            this.viewURI = viewURI;
        }

        @Override
        public void createControls(Composite body, IWorkbenchSite site) {
            try {
                final SWTViewLoaderProcess loader = new SWTViewLoaderProcess(null, site);
                SWTRoot root = (SWTRoot)loader.load(this.viewURI, this.runtime);
                root.createControls(body);
                body.addListener(12, new Listener(){

                    public void handleEvent(Event event) {
                        if (!loader.isDisposed()) {
                            loader.dispose();
                        }
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                Logger.defaultLogError((Throwable)e);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Contribution)) {
                return false;
            }
            Contribution c = (Contribution)obj;
            return this.viewURI.equals(c.viewURI);
        }

        public int hashCode() {
            return this.viewURI.hashCode();
        }
    }
}

