/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.sorters.AbstractSorter;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.browsing.ui.model.sorters.SorterRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.selectionview.CategoryNode;
import org.simantics.selectionview.SelectionViewUtils;
import org.simantics.utils.datastructures.ComparablePair;

public class StandardPropertySorterRule
implements SorterRule {
    private final Sorter sorter;

    public StandardPropertySorterRule(Resource rule) {
        this.sorter = new StandardSorter(rule);
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    public Sorter getSorter(ReadGraph graph, Object content) throws DatabaseException {
        return this.sorter;
    }

    static class StandardSorter
    extends AbstractSorter<ComparablePair<String, String>> {
        private final Resource rule;

        public StandardSorter(Resource rule) {
            this.rule = rule;
        }

        public ComparablePair<String, String> getSortingCriterion(ReadGraph graph, BrowseContext context, NodeContext node) throws DatabaseException {
            Object content = node.getConstant(BuiltinKeys.INPUT);
            if (content instanceof Variable) {
                String label;
                String cat;
                Variable var = (Variable)content;
                Variable info = var.getPossibleProperty(graph, "HasStandardPropertyInfo");
                if (info == null) {
                    return ComparablePair.make((Comparable)((Object)""), (Comparable)((Object)((Variable)content).getName(graph)));
                }
                Variable special = SelectionViewUtils.getSpecialCategory(graph, this.rule, info);
                if (special != null) {
                    info = special;
                }
                if ((cat = (String)info.getPossiblePropertyValue(graph, "CategorySortingName", (Binding)Bindings.STRING)) == null && (cat = (String)info.getPossiblePropertyValue(graph, "CategoryName", (Binding)Bindings.STRING)) == null) {
                    cat = "";
                }
                if ((label = (String)((Variable)content).getPossiblePropertyValue(graph, "SortingName", (Binding)Bindings.STRING)) == null) {
                    label = (String)((Variable)content).getPossiblePropertyValue(graph, "HasDisplayProperty", (Binding)Bindings.STRING);
                }
                if (label == null) {
                    label = "Invalid label for " + ((Variable)content).getURI(graph);
                }
                return ComparablePair.make((Comparable)((Object)cat), (Comparable)((Object)label));
            }
            if (content instanceof CategoryNode) {
                return ComparablePair.make((Comparable)((Object)((CategoryNode)content).getSortingName()), (Comparable)((Object)""));
            }
            throw new IllegalArgumentException("Content type should be Variable or CategoryNode");
        }

        public int compare(ComparablePair<String, String> a, ComparablePair<String, String> b) {
            return a.compareTo(b);
        }
    }
}

