package org.simantics.selectionview;

import java.util.Collection;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function;
import org.simantics.views.swt.SWTViewLoaderProcess;
import org.simantics.views.swt.client.base.SWTRoot;

public class VariableTabContribution implements TabContribution<Variable> {

	final private Resource configuration;

	public VariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
		this.configuration = configuration;
	}

	@Override
	public boolean accept(ReadGraph graph, Object input) {
		return (input instanceof Variable);
	}

	@Override
	public void contribute(ReadGraph graph, final Variable variable, Collection<ComparableTabContributor> result) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		SelectionViewResources SEL = SelectionViewResources.getInstance(graph);

		Resource view = graph.getPossibleObject(configuration, SEL.VariableTabContribution_HasView);
		if(view == null) throw new DatabaseException("No view for " + graph.getPossibleURI(configuration));

		Integer priority = graph.getPossibleRelatedValue(configuration, SEL.VariableTabContribution_HasPriority, Bindings.INTEGER);
		String label = graph.getPossibleRelatedValue(configuration, L0.HasLabel);
		
		for(Resource r : graph.getObjects(configuration, SEL.VariableTabContribution_HasTest)) {
			Boolean pass = Functions.exec(graph, r, graph, variable);
			if(!pass) return;
		}
		
		Variable configurationVariable = Variables.getVariable(graph, configuration);
		Function f = configurationVariable.getPossiblePropertyValue(graph, SEL.AbstractVariableTabContribution_testFunction);
		if(f != null) {
			Boolean pass = Simantics.<Boolean>applySCLRead(graph, f, variable);
			if(!pass) return;
		}

		final String viewURI = graph.getPossibleURI(view);
		
		result.add(new ComparableTabContributor(new ModelledTabContributor() {

			@Override
			public void createControls(Composite body, IWorkbenchSite site) {

				try {

					final SWTViewLoaderProcess loader = new SWTViewLoaderProcess(null, site);
					SWTRoot root = loader.load(viewURI, runtime);
					root.createControls(body);
					body.addListener(SWT.Dispose, new Listener() {
						
						@Override
						public void handleEvent(Event event) {
							if(!loader.isDisposed())
								loader.dispose();
						}
						
					});

				} catch (DatabaseException e) {

					e.printStackTrace();
					Logger.defaultLogError(e);

				}

			}

		}, priority, variable, label));

	}

}
